/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.configuration.helpers;

import java.net.BindException;
import org.neo4j.configuration.helpers.SocketAddress;

public class PortBindException
extends BindException {
    public PortBindException(SocketAddress address, Throwable original) {
        this(address, null, original);
    }

    public PortBindException(java.net.SocketAddress address, Throwable original) {
        super("An error occurred while trying to bind to the socket " + address);
        this.initCause(original);
    }

    public PortBindException(SocketAddress address1, SocketAddress address2, Throwable original) {
        super(PortBindException.createMessage(address1, address2));
        this.setStackTrace(original.getStackTrace());
    }

    private static String createMessage(SocketAddress address1, SocketAddress address2) {
        if (address1 == null && address2 == null) {
            return "Address is already in use, cannot bind to it.";
        }
        if (address1 != null && address2 != null) {
            return String.format("At least one of the addresses %s or %s is already in use, cannot bind to it.", address1, address2);
        }
        return String.format("Address %s is already in use, cannot bind to it.", address1 != null ? address1 : address2);
    }
}

