/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.helpers.progress;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import org.neo4j.internal.helpers.progress.Indicator;
import org.neo4j.internal.helpers.progress.ProgressListener;
import org.neo4j.internal.helpers.progress.ProgressMonitorFactory;

final class Aggregator {
    private final Map<ProgressListener, State> states = new HashMap<ProgressListener, State>();
    private final Indicator indicator;
    private volatile long progress;
    private volatile int last;
    private static final AtomicLongFieldUpdater<Aggregator> PROGRESS_UPDATER = AtomicLongFieldUpdater.newUpdater(Aggregator.class, "progress");
    private static final AtomicIntegerFieldUpdater<Aggregator> LAST_UPDATER = AtomicIntegerFieldUpdater.newUpdater(Aggregator.class, "last");
    private volatile long totalCount;

    Aggregator(Indicator indicator) {
        this.indicator = indicator;
    }

    synchronized void add(ProgressListener progress, long totalCount) {
        this.states.put(progress, State.INIT);
        this.totalCount += totalCount;
    }

    synchronized ProgressMonitorFactory.Completer initialize() {
        this.indicator.startProcess(this.totalCount);
        if (this.states.isEmpty()) {
            this.indicator.progress(0, this.indicator.reportResolution());
        }
        ArrayList<ProgressListener> progressesToClose = new ArrayList<ProgressListener>(this.states.keySet());
        return () -> progressesToClose.forEach(ProgressListener::close);
    }

    void update(long delta) {
        long progress = Long.min(this.totalCount, PROGRESS_UPDATER.addAndGet(this, delta));
        int current = (int)(progress * (long)this.indicator.reportResolution() / this.totalCount);
        this.updateTo(current);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateTo(int to) {
        int last = this.last;
        while (to > last) {
            if (LAST_UPDATER.compareAndSet(this, last, to)) {
                Aggregator aggregator = this;
                synchronized (aggregator) {
                    this.indicator.progress(last, to);
                }
            }
            last = this.last;
        }
    }

    void updateRemaining() {
        this.updateTo(this.indicator.reportResolution());
    }

    synchronized void start(ProgressListener.MultiPartProgressListener part) {
        this.states.put(part, State.LIVE);
    }

    synchronized void complete(ProgressListener.MultiPartProgressListener part) {
        if (this.states.remove(part) != null && this.states.isEmpty()) {
            this.updateRemaining();
        }
    }

    synchronized void signalFailure(Throwable e) {
        this.indicator.failure(e);
    }

    void done() {
        this.states.keySet().forEach(ProgressListener::close);
    }

    void mark(char mark) {
        this.indicator.mark(mark);
    }

    static enum State {
        INIT,
        LIVE;

    }
}

