/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.string;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.security.SecureRandom;
import java.util.Arrays;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.neo4j.annotations.api.PublicApi;

@PublicApi
public class SecureString {
    private static final SecureRandom random = new SecureRandom();
    private Cipher cipher;
    private byte[] encryptedData;
    private boolean encryptionAvailable;
    private byte[] obfuscationKey;
    private static final Charset encoding = StandardCharsets.UTF_8;

    public SecureString(String stringToSecure) {
        this(stringToSecure, true);
    }

    SecureString(String stringToSecure, boolean tryUseEncryption) {
        this(stringToSecure != null ? stringToSecure.getBytes(encoding) : null, tryUseEncryption);
    }

    private SecureString(byte[] dataToSecure, boolean tryUseEncryption) {
        if (dataToSecure != null) {
            if (tryUseEncryption) {
                try {
                    byte[] buf = new byte[16];
                    random.nextBytes(buf);
                    SecretKeySpec aesKey = new SecretKeySpec(buf, "AES");
                    this.cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
                    random.nextBytes(buf);
                    IvParameterSpec iv = new IvParameterSpec(buf);
                    Arrays.fill(buf, (byte)0);
                    this.cipher.init(1, (Key)aesKey, iv);
                    this.encryptedData = this.cipher.doFinal(dataToSecure);
                    this.cipher.init(2, (Key)aesKey, iv);
                    this.encryptionAvailable = true;
                }
                catch (Exception e) {
                    this.encryptionAvailable = false;
                }
            }
            if (!this.encryptionAvailable) {
                this.obfuscationKey = new byte[16];
                random.nextBytes(this.obfuscationKey);
                this.encryptedData = SecureString.XOR(dataToSecure, this.obfuscationKey);
            }
        } else {
            this.encryptedData = null;
            this.encryptionAvailable = tryUseEncryption;
        }
    }

    boolean encryptionAvailable() {
        return this.encryptionAvailable;
    }

    private byte[] getData() {
        if (this.encryptedData == null) {
            return null;
        }
        if (this.encryptionAvailable()) {
            try {
                return this.cipher.doFinal(this.encryptedData);
            }
            catch (Exception e) {
                throw new RuntimeException("Data corruption, could not decrypt data");
            }
        }
        return SecureString.XOR(this.encryptedData, this.obfuscationKey);
    }

    private static byte[] XOR(byte[] input, byte[] key) {
        byte[] output = Arrays.copyOf(input, input.length);
        for (int i = 0; i < input.length; ++i) {
            output[i] = (byte)(input[i] ^ key[i % key.length]);
        }
        return output;
    }

    public String getString() {
        byte[] data = this.getData();
        return data != null ? new String(this.getData(), encoding) : null;
    }

    public String toString() {
        return "################";
    }
}

