/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.scheduler;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import org.neo4j.scheduler.Group;
import org.neo4j.scheduler.SchedulerThreadFactory;

interface ExecutorServiceFactory {
    public ExecutorService build(Group var1, SchedulerThreadFactory var2, int var3);

    public static ExecutorServiceFactory unschedulable() {
        return (group, factory, threadCount) -> new ThrowingExecutorService(group);
    }

    public static ExecutorServiceFactory singleThread() {
        return (group, factory, threadCount) -> Executors.newSingleThreadExecutor(factory);
    }

    public static ExecutorServiceFactory cached() {
        return (group, factory, threadCount) -> {
            if (threadCount == 0) {
                return Executors.newCachedThreadPool(factory);
            }
            return Executors.newFixedThreadPool(threadCount, factory);
        };
    }

    public static ExecutorServiceFactory workStealing() {
        return (group, factory, threadCount) -> {
            if (threadCount == 0) {
                threadCount = Runtime.getRuntime().availableProcessors();
            }
            return new ForkJoinPool(threadCount, factory, null, false);
        };
    }

    public static ExecutorServiceFactory workStealingAsync() {
        return (group, factory, threadCount) -> {
            if (threadCount == 0) {
                threadCount = Runtime.getRuntime().availableProcessors();
            }
            return new ForkJoinPool(threadCount, factory, null, true);
        };
    }

    public static class ThrowingExecutorService
    implements ExecutorService {
        private final Group group;
        private volatile boolean shutodwn;

        private ThrowingExecutorService(Group group) {
            this.group = group;
        }

        @Override
        public void shutdown() {
            this.shutodwn = true;
        }

        @Override
        public List<Runnable> shutdownNow() {
            return Collections.emptyList();
        }

        @Override
        public boolean isShutdown() {
            return this.shutodwn;
        }

        @Override
        public boolean isTerminated() {
            return this.shutodwn;
        }

        @Override
        public boolean awaitTermination(long timeout, TimeUnit unit) {
            return true;
        }

        @Override
        public <T> Future<T> submit(Callable<T> task) {
            throw ThrowingExecutorService.newUnschedulableException(this.group);
        }

        @Override
        public <T> Future<T> submit(Runnable task, T result) {
            throw ThrowingExecutorService.newUnschedulableException(this.group);
        }

        @Override
        public Future<?> submit(Runnable task) {
            throw ThrowingExecutorService.newUnschedulableException(this.group);
        }

        @Override
        public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks) {
            throw ThrowingExecutorService.newUnschedulableException(this.group);
        }

        @Override
        public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) {
            throw ThrowingExecutorService.newUnschedulableException(this.group);
        }

        @Override
        public <T> T invokeAny(Collection<? extends Callable<T>> tasks) {
            throw ThrowingExecutorService.newUnschedulableException(this.group);
        }

        @Override
        public <T> T invokeAny(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) {
            throw ThrowingExecutorService.newUnschedulableException(this.group);
        }

        @Override
        public void execute(Runnable command) {
            throw ThrowingExecutorService.newUnschedulableException(this.group);
        }

        private static RejectedExecutionException newUnschedulableException(Group group) {
            return new RejectedExecutionException("Tasks cannot be scheduled directly to the " + group.groupName() + " group.");
        }
    }
}

