/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.memory;

import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.LongAccumulator;
import org.neo4j.memory.MemoryAllocationTracker;

public class ThreadSafePeakMemoryAllocationTracker
implements MemoryAllocationTracker {
    private final AtomicLong allocated = new AtomicLong();
    private final LongAccumulator peak = new LongAccumulator(Long::max, 0L);

    @Override
    public void allocated(long bytes) {
        long total = this.allocated.addAndGet(bytes);
        this.peak.accumulate(total);
    }

    @Override
    public void deallocated(long bytes) {
        this.allocated.addAndGet(-bytes);
    }

    @Override
    public long usedDirectMemory() {
        return this.allocated.get();
    }

    public long peakMemoryUsage() {
        return this.peak.get();
    }
}

