/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.common;

import java.util.Iterator;
import java.util.function.Supplier;
import org.neo4j.exceptions.UnsatisfiedDependencyException;

public interface DependencyResolver {
    public <T> T resolveDependency(Class<T> var1) throws IllegalArgumentException, UnsatisfiedDependencyException;

    public <T> T resolveDependency(Class<T> var1, SelectionStrategy var2) throws IllegalArgumentException, UnsatisfiedDependencyException;

    default public <T> Iterable<? extends T> resolveTypeDependencies(Class<T> type) {
        throw new UnsupportedOperationException("not implemented");
    }

    public <T> Supplier<T> provideDependency(Class<T> var1, SelectionStrategy var2);

    public <T> Supplier<T> provideDependency(Class<T> var1);

    public static abstract class Adapter
    implements DependencyResolver {
        @Override
        public <T> T resolveDependency(Class<T> type) throws IllegalArgumentException {
            return this.resolveDependency(type, SelectionStrategy.SINGLE);
        }

        @Override
        public <T> Supplier<T> provideDependency(Class<T> type, SelectionStrategy selector) {
            return () -> this.resolveDependency(type, selector);
        }

        @Override
        public <T> Supplier<T> provideDependency(Class<T> type) {
            return () -> this.resolveDependency(type);
        }
    }

    public static interface SelectionStrategy {
        public static final SelectionStrategy FIRST = new SelectionStrategy(){

            @Override
            public <T> T select(Class<T> type, Iterable<? extends T> candidates) throws IllegalArgumentException {
                Iterator<T> iterator = candidates.iterator();
                if (!iterator.hasNext()) {
                    throw new IllegalArgumentException("Could not resolve dependency of type:" + type.getName());
                }
                return iterator.next();
            }
        };
        public static final SelectionStrategy SINGLE = new SelectionStrategy(){

            @Override
            public <T> T select(Class<T> type, Iterable<? extends T> candidates) throws IllegalArgumentException {
                Iterator<T> iterator = candidates.iterator();
                if (!iterator.hasNext()) {
                    throw new IllegalArgumentException("Could not resolve dependency of type:" + type.getName());
                }
                T only = iterator.next();
                if (iterator.hasNext()) {
                    throw new IllegalArgumentException("Multiple dependencies of type:" + type.getName());
                }
                return only;
            }
        };

        public <T> T select(Class<T> var1, Iterable<? extends T> var2) throws IllegalArgumentException;
    }
}

