/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.resources;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.LockSupport;
import org.neo4j.resources.Profiler;

class SamplingProfiler
implements Profiler {
    private static final long DEFAULT_SAMPLE_INTERVAL_NANOS = TimeUnit.MILLISECONDS.toNanos(1L);
    private final ArrayList<Thread> samplerThreads = new ArrayList();
    private final AtomicBoolean stopped = new AtomicBoolean();
    private final ConcurrentHashMap<Thread, Sample> samples = new ConcurrentHashMap();
    private final AtomicLong sampleIntervalNanos = new AtomicLong(DEFAULT_SAMPLE_INTERVAL_NANOS);
    private final AtomicLong underSampling = new AtomicLong();

    SamplingProfiler() {
    }

    @Override
    public void reset() {
        this.stopped.set(false);
        this.samples.clear();
        this.underSampling.set(0L);
    }

    @Override
    public void finish() throws InterruptedException {
        this.stopped.set(true);
        for (Thread thread : this.samplerThreads) {
            thread.interrupt();
            thread.join();
        }
        this.samplerThreads.clear();
    }

    @Override
    public void printProfile(PrintStream out, String profileTitle) {
        out.println("### " + profileTitle);
        if (this.underSampling.get() > 0L) {
            long allSamplesTotal = this.samples.reduceToLong(Long.MAX_VALUE, (thread, sample) -> sample.get(), 0L, (a, b) -> a + b);
            out.println("Info: Did not achieve target sampling frequency. " + this.underSampling + " of " + allSamplesTotal + " samples were delayed.");
        }
        for (Map.Entry<Thread, Sample> entry : this.samples.entrySet()) {
            Thread thread2 = entry.getKey();
            Sample rootSample = entry.getValue();
            rootSample.intoOrdered();
            out.println("Profile (" + rootSample.get() + " samples) " + thread2.getName());
            double total = rootSample.get();
            this.printSampleTree(out, total, rootSample.orderedChildren, 2);
        }
    }

    @Override
    public void setSampleIntervalNanos(long nanos) {
        this.sampleIntervalNanos.set(nanos);
    }

    @Override
    public Profiler.ProfiledInterval profile(Thread threadToProfile, long initialDelayNanos) {
        long capturedSampleIntervalNanos = this.sampleIntervalNanos.get();
        long baseline = System.nanoTime();
        Thread samplerThread = new Thread(() -> {
            long nextSleepBaseline = initialDelayNanos > 0L ? this.sleep(baseline, initialDelayNanos) : baseline;
            Sample root = this.samples.computeIfAbsent(threadToProfile, k -> new Sample(null));
            while (!this.stopped.get() && threadToProfile.isAlive()) {
                StackTraceElement[] frames = threadToProfile.getStackTrace();
                if (Thread.currentThread().isInterrupted()) break;
                this.record(root, frames);
                nextSleepBaseline = this.sleep(nextSleepBaseline, capturedSampleIntervalNanos);
            }
        });
        this.samplerThreads.add(samplerThread);
        samplerThread.setName("Sampler for " + threadToProfile.getName());
        samplerThread.setPriority(6);
        samplerThread.setDaemon(true);
        samplerThread.start();
        return samplerThread::interrupt;
    }

    private long sleep(long baselineNanos, long delayNanoes) {
        long nextBaseline = System.nanoTime();
        long sleepNanos = delayNanoes - (nextBaseline - baselineNanos);
        if (sleepNanos > 0L) {
            LockSupport.parkNanos(this, sleepNanos);
        } else {
            this.underSampling.getAndIncrement();
            Thread.yield();
        }
        return nextBaseline + delayNanoes;
    }

    private void record(Sample root, StackTraceElement[] frames) {
        root.getAndIncrement();
        Map level = root.children;
        for (int i = frames.length - 1; i >= 0; --i) {
            StackTraceElement frame = frames[i];
            Sample sample = level.computeIfAbsent(frame, x$0 -> new Sample((StackTraceElement)x$0));
            sample.getAndIncrement();
            level = sample.children;
        }
    }

    private void printSampleTree(PrintStream out, double total, PriorityQueue<Sample> children, int indent) {
        Sample child;
        while ((child = children.poll()) != null) {
            for (int i = 0; i < indent; ++i) {
                out.print(' ');
            }
            out.printf("%.2f%%: %s%n", (double)child.get() / total * 100.0, child.stackTraceElement);
            this.printSampleTree(out, total, child.orderedChildren, indent + 2);
        }
    }

    private static final class Sample
    extends AtomicLong
    implements Comparable<Sample> {
        private final StackTraceElement stackTraceElement;
        private Map<StackTraceElement, Sample> children;
        private PriorityQueue<Sample> orderedChildren;

        private Sample(StackTraceElement stackTraceElement) {
            this.stackTraceElement = stackTraceElement;
            this.children = new ConcurrentHashMap<StackTraceElement, Sample>();
        }

        @Override
        public int compareTo(Sample o) {
            return Long.compare(o.get(), this.get());
        }

        void intoOrdered() {
            this.orderedChildren = new PriorityQueue();
            this.orderedChildren.addAll(this.children.values());
            this.children.clear();
            for (Sample child : this.orderedChildren) {
                child.intoOrdered();
            }
        }
    }
}

