/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.time;

import java.time.Clock;
import java.time.temporal.ChronoField;
import java.time.temporal.TemporalAccessor;
import java.util.concurrent.TimeUnit;
import org.neo4j.time.FakeClock;
import org.neo4j.time.SystemNanoClock;

public class Clocks {
    private static final Clock SYSTEM_CLOCK = Clock.systemUTC();

    private Clocks() {
    }

    public static Clock systemClock() {
        return SYSTEM_CLOCK;
    }

    public static SystemNanoClock nanoClock() {
        return SystemNanoClock.INSTANCE;
    }

    public static FakeClock fakeClock() {
        return new FakeClock();
    }

    public static FakeClock fakeClock(long initialTime, TimeUnit unit) {
        return new FakeClock(initialTime, unit);
    }

    public static FakeClock fakeClock(TemporalAccessor initialTime) {
        return new FakeClock(initialTime.getLong(ChronoField.INSTANT_SECONDS), TimeUnit.SECONDS).forward(initialTime.getLong(ChronoField.NANO_OF_SECOND), TimeUnit.NANOSECONDS);
    }
}

