/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.time;

import java.lang.management.ManagementFactory;
import java.lang.management.ThreadMXBean;

public abstract class CpuClock {
    public static CpuClock CPU_CLOCK = new CpuClock(){
        private final ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();

        @Override
        public long cpuTimeNanos(long threadId) {
            if (!this.threadMXBean.isThreadCpuTimeSupported()) {
                return -1L;
            }
            if (!this.threadMXBean.isThreadCpuTimeEnabled()) {
                this.threadMXBean.setThreadCpuTimeEnabled(true);
            }
            return this.threadMXBean.getThreadCpuTime(threadId);
        }
    };

    public final long cpuTimeNanos(Thread thread) {
        return this.cpuTimeNanos(thread.getId());
    }

    public abstract long cpuTimeNanos(long var1);
}

