/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.function;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.BooleanSupplier;
import java.util.function.IntPredicate;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import org.neo4j.function.Suppliers;
import org.neo4j.function.ThrowingSupplier;

public class Predicates {
    private static final Predicate TRUE = item -> true;
    private static final Predicate FALSE = item -> false;
    private static final Predicate NOT_NULL = item -> item != null;
    private static final int DEFAULT_POLL_INTERVAL = 20;
    public static IntPredicate ALWAYS_TRUE_INT = value -> true;

    public static <T> Predicate<T> alwaysTrue() {
        return TRUE;
    }

    public static <T> Predicate<T> alwaysFalse() {
        return FALSE;
    }

    public static <T> Predicate<T> notNull() {
        return NOT_NULL;
    }

    @SafeVarargs
    public static <T> Predicate<T> all(Predicate<T> ... predicates) {
        return Predicates.all(Arrays.asList(predicates));
    }

    public static <T> Predicate<T> all(Iterable<Predicate<T>> predicates) {
        return item -> {
            for (Predicate predicate : predicates) {
                if (predicate.test(item)) continue;
                return false;
            }
            return true;
        };
    }

    @SafeVarargs
    public static <T> Predicate<T> any(Predicate<T> ... predicates) {
        return Predicates.any(Arrays.asList(predicates));
    }

    public static <T> Predicate<T> any(Iterable<Predicate<T>> predicates) {
        return item -> {
            for (Predicate predicate : predicates) {
                if (!predicate.test(item)) continue;
                return true;
            }
            return false;
        };
    }

    public static <T> Predicate<T> instanceOf(@Nonnull Class clazz) {
        return item -> item != null && clazz.isInstance(item);
    }

    public static <T> Predicate<T> instanceOfAny(Class ... classes) {
        return item -> {
            if (item != null) {
                for (Class clazz : classes) {
                    if (!clazz.isInstance(item)) continue;
                    return true;
                }
            }
            return false;
        };
    }

    public static <T> Predicate<T> noDuplicates() {
        return new Predicate<T>(){
            private final Set<T> visitedItems = new HashSet();

            @Override
            public boolean test(T item) {
                return this.visitedItems.add(item);
            }
        };
    }

    public static <TYPE> void await(Supplier<TYPE> supplier, Predicate<TYPE> predicate, long timeout, TimeUnit timeoutUnit, long pollInterval, TimeUnit pollUnit) throws TimeoutException, InterruptedException {
        Predicates.await(Suppliers.compose(supplier, predicate), timeout, timeoutUnit, pollInterval, pollUnit);
    }

    public static <TYPE> void await(Supplier<TYPE> supplier, Predicate<TYPE> predicate, long timeout, TimeUnit timeoutUnit) throws TimeoutException, InterruptedException {
        Predicates.await(Suppliers.compose(supplier, predicate), timeout, timeoutUnit);
    }

    public static void await(Supplier<Boolean> condition, long timeout, TimeUnit unit) throws TimeoutException, InterruptedException {
        Predicates.awaitEx(condition::get, timeout, unit);
    }

    public static <EXCEPTION extends Exception> void awaitEx(ThrowingSupplier<Boolean, EXCEPTION> condition, long timeout, TimeUnit unit) throws TimeoutException, InterruptedException, EXCEPTION {
        Predicates.awaitEx(condition, timeout, unit, 20L, TimeUnit.MILLISECONDS);
    }

    public static <EXCEPTION extends Exception> void awaitEx(ThrowingSupplier<Boolean, EXCEPTION> condition, long timeout, TimeUnit unit, long pollInterval, TimeUnit pollUnit) throws TimeoutException, InterruptedException, EXCEPTION {
        if (!Predicates.tryAwaitEx(condition, timeout, unit, pollInterval, pollUnit)) {
            throw new TimeoutException("Waited for " + timeout + " " + (Object)((Object)unit) + ", but " + condition + " was not accepted.");
        }
    }

    public static void await(Supplier<Boolean> condition, long timeout, TimeUnit timeoutUnit, long pollInterval, TimeUnit pollUnit) throws TimeoutException, InterruptedException {
        Predicates.awaitEx(condition::get, timeout, timeoutUnit, pollInterval, pollUnit);
    }

    public static boolean tryAwait(Supplier<Boolean> condition, long timeout, TimeUnit timeoutUnit, long pollInterval, TimeUnit pollUnit) throws InterruptedException {
        return Predicates.tryAwaitEx(condition::get, timeout, timeoutUnit, pollInterval, pollUnit);
    }

    public static <EXCEPTION extends Exception> boolean tryAwaitEx(ThrowingSupplier<Boolean, EXCEPTION> condition, long timeout, TimeUnit timeoutUnit, long pollInterval, TimeUnit pollUnit) throws InterruptedException, EXCEPTION {
        long deadlineMillis = System.currentTimeMillis() + timeoutUnit.toMillis(timeout);
        long pollIntervalMillis = pollUnit.toMillis(pollInterval);
        do {
            if (condition.get().booleanValue()) {
                return true;
            }
            Thread.sleep(pollIntervalMillis);
        } while (System.currentTimeMillis() < deadlineMillis);
        return false;
    }

    public static void awaitForever(BooleanSupplier condition, long checkInterval, TimeUnit unit) throws InterruptedException {
        long sleep = unit.toMillis(checkInterval);
        while (!condition.getAsBoolean()) {
            Thread.sleep(sleep);
        }
        return;
    }

    public static <T> Predicate<T> in(T ... allowed) {
        return Predicates.in(Arrays.asList(allowed));
    }

    public static <T> Predicate<T> not(Predicate<T> predicate) {
        return t -> !predicate.test(t);
    }

    public static <T> Predicate<T> in(Iterable<T> allowed) {
        return item -> {
            for (Object allow : allowed) {
                if (!allow.equals(item)) continue;
                return true;
            }
            return false;
        };
    }
}

