/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.exceptions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;

public interface Status {
    public Code code();

    public static interface HasStatus {
        public Status status();
    }

    public static enum Classification {
        ClientError(TransactionEffect.ROLLBACK, PublishingPolicy.PUBLISHABLE, "The Client sent a bad request - changing the request might yield a successful outcome."),
        ClientNotification(TransactionEffect.NONE, PublishingPolicy.PUBLISHABLE, "There are notifications about the request sent by the client."),
        TransientError(TransactionEffect.ROLLBACK, PublishingPolicy.PUBLISHABLE, "The database cannot service the request right now, retrying later might yield a successful outcome. "),
        DatabaseError(TransactionEffect.ROLLBACK, PublishingPolicy.INTERNAL, "The database failed to service the request. ");

        private final boolean rollbackTransaction;
        private final boolean publishable;
        private final String description;

        private Classification(TransactionEffect transactionEffect, PublishingPolicy publishingPolicy, String description) {
            this.description = description;
            this.publishable = publishingPolicy == PublishingPolicy.PUBLISHABLE;
            this.rollbackTransaction = transactionEffect == TransactionEffect.ROLLBACK;
        }

        public boolean rollbackTransaction() {
            return this.rollbackTransaction;
        }

        public boolean publishable() {
            return this.publishable;
        }

        public String description() {
            return this.description;
        }

        private static enum PublishingPolicy {
            PUBLISHABLE,
            INTERNAL;

        }

        private static enum TransactionEffect {
            ROLLBACK,
            NONE;

        }
    }

    public static class Code {
        private final Classification classification;
        private final String description;
        private final String category;
        private final String title;

        public static Collection<Status> all() {
            ArrayList<Status> result = new ArrayList<Status>();
            for (Class<?> child : Status.class.getDeclaredClasses()) {
                if (!child.isEnum() || !Status.class.isAssignableFrom(child)) continue;
                Class<?> statusType = child;
                Collections.addAll(result, statusType.getEnumConstants());
            }
            return result;
        }

        <C extends Enum<C>> Code(Classification classification, C categoryAndTitle, String description) {
            this.classification = classification;
            this.category = categoryAndTitle.getDeclaringClass().getSimpleName();
            this.title = categoryAndTitle.name();
            this.description = description;
        }

        public String toString() {
            return "Status.Code[" + this.serialize() + "]";
        }

        public final String serialize() {
            return String.format("Neo.%s.%s.%s", new Object[]{this.classification, this.category, this.title});
        }

        public final String description() {
            return this.description;
        }

        public Classification classification() {
            return this.classification;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Code code = (Code)o;
            if (!this.category.equals(code.category)) {
                return false;
            }
            if (this.classification != code.classification) {
                return false;
            }
            return this.title.equals(code.title);
        }

        public int hashCode() {
            int result = this.classification.hashCode();
            result = 31 * result + this.category.hashCode();
            result = 31 * result + this.title.hashCode();
            return result;
        }
    }

    public static enum General implements Status
    {
        ReadOnly(Classification.ClientError, "This is a read only database, writing or modifying the database is not allowed."),
        FailedIndex(Classification.DatabaseError, "The request (directly or indirectly) referred to an index that is in a failed state. The index needs to be dropped and recreated manually."),
        UnknownFailure(Classification.DatabaseError, "An unknown failure occurred."),
        DatabaseUnavailable(Classification.TransientError, "The database is not currently available to serve your request, refer to the database logs for more details. Retrying your request at a later time may succeed."),
        CorruptSchemaRule(Classification.DatabaseError, "A malformed schema rule was encountered. Please contact your support representative.");

        private final Code code;

        @Override
        public Code code() {
            return this.code;
        }

        private General(Classification classification, String description) {
            this.code = new Code(classification, this, description);
        }
    }

    public static enum Security implements Status
    {
        AuthenticationFailed(Classification.ClientError, "The client provided an incorrect username and/or password."),
        CredentialsExpired(Classification.ClientError, "The credentials have expired and need to be updated."),
        AuthorizationFailed(Classification.ClientError, "The client does not have privileges to perform the operation requested."),
        AuthenticationRateLimit(Classification.ClientError, "The client has provided incorrect authentication details too many times in a row."),
        ModifiedConcurrently(Classification.TransientError, "The user was modified concurrently to this request."),
        EncryptionRequired(Classification.ClientError, "A TLS encrypted connection is required."),
        AccessViolation(Classification.ClientError, "An attempt was made to perform an unauthorized action.");

        private final Code code;

        @Override
        public Code code() {
            return this.code;
        }

        private Security(Classification classification, String description) {
            this.code = new Code(classification, this, description);
        }
    }

    public static enum Procedure implements Status
    {
        FailedRegistration(Classification.ClientError, "The database failed to register a procedure, refer to the associated error message for details."),
        NoSuchProcedure(Classification.ClientError, "A request referred to a procedure that is not registered with this database instance. If you are deploying custom procedures in a cluster setup, ensure all instances in the cluster have the procedure jar file deployed."),
        CallFailed(Classification.ClientError, "Failed to invoke a procedure. See the detailed error description for exact cause."),
        TypeError(Classification.ClientError, "A procedure is using or receiving a value of an invalid type.");

        private final Code code;

        @Override
        public Code code() {
            return this.code;
        }

        private Procedure(Classification classification, String description) {
            this.code = new Code(classification, this, description);
        }
    }

    public static enum LegacyIndex implements Status
    {
        NoSuchIndex(Classification.ClientError, "The request (directly or indirectly) referred to a index that does not exist.");

        private final Code code;

        @Override
        public Code code() {
            return this.code;
        }

        private LegacyIndex(Classification classification, String description) {
            this.code = new Code(classification, this, description);
        }
    }

    public static enum Schema implements Status
    {
        ConstraintViolation(Classification.ClientError, "A constraint imposed by the database was violated."),
        NoSuchIndex(Classification.ClientError, "The request (directly or indirectly) referred to an index that does not exist."),
        NoSuchConstraint(Classification.ClientError, "The request (directly or indirectly) referred to a constraint that does not exist."),
        IndexCreationFailure(Classification.DatabaseError, "Failed to create an index."),
        ConstraintAlreadyExists(Classification.ClientError, "Unable to perform operation because it would clash with a pre-existing constraint."),
        IndexAlreadyExists(Classification.ClientError, "Unable to perform operation because it would clash with a pre-existing index."),
        IndexDropFailure(Classification.DatabaseError, "The database failed to drop a requested index."),
        ConstraintVerificationFailure(Classification.ClientError, "Unable to create constraint because data that exists in the database violates it."),
        ConstraintCreationFailure(Classification.DatabaseError, "Creating a requested constraint failed."),
        ConstraintDropFailure(Classification.DatabaseError, "The database failed to drop a requested constraint."),
        IllegalTokenName(Classification.ClientError, "A token name, such as a label, relationship type or property key, used is not valid. Tokens cannot be empty strings and cannot be null."),
        IndexBelongsToConstraint(Classification.ClientError, "A requested operation can not be performed on the specified index because the index is part of a constraint. If you want to drop the index, for instance, you must drop the constraint."),
        NoSuchLabel(Classification.DatabaseError, "The request accessed a label that did not exist."),
        NoSuchPropertyKey(Classification.DatabaseError, "The request accessed a property that does not exist."),
        NoSuchRelationshipType(Classification.DatabaseError, "The request accessed a relationship type that does not exist."),
        NoSuchSchemaRule(Classification.DatabaseError, "The request referred to a schema rule that does not exist."),
        DuplicateSchemaRule(Classification.DatabaseError, "The request referred to a schema rule that defined multiple times."),
        LabelLimitReached(Classification.ClientError, "The maximum number of labels supported has been reached, no more labels can be created."),
        IndexLimitReached(Classification.ClientError, "The maximum number of index entries supported has been reached, no more entities can be indexed."),
        ModifiedConcurrently(Classification.TransientError, "The database schema was modified while this transaction was running, the transaction should be retried.");

        private final Code code;

        @Override
        public Code code() {
            return this.code;
        }

        private Schema(Classification classification, String description) {
            this.code = new Code(classification, this, description);
        }
    }

    public static enum Statement implements Status
    {
        InvalidSyntax(Classification.ClientError, "The statement contains invalid or unsupported syntax."),
        InvalidSemantics(Classification.ClientError, "The statement is syntactically valid, but expresses something that the database cannot do."),
        ParameterMissing(Classification.ClientError, "The statement is referring to a parameter that was not provided in the request."),
        ConstraintViolation(Classification.ClientError, "A constraint imposed by the statement is violated by the data in the database."),
        EntityNotFound(Classification.ClientError, "The statement is directly referring to an entity that does not exist."),
        NoSuchProperty(Classification.ClientError, "The statement is referring to a property that does not exist."),
        NoSuchLabel(Classification.ClientError, "The statement is referring to a label that does not exist."),
        InvalidType(Classification.ClientError, "The statement is attempting to perform operations on values with types that are not supported by the operation."),
        InvalidArguments(Classification.ClientError, "The statement is attempting to perform operations using invalid arguments"),
        ArithmeticError(Classification.ClientError, "Invalid use of arithmetic, such as dividing by zero."),
        ExecutionFailure(Classification.DatabaseError, "The database was unable to execute the statement."),
        ExternalResourceFailure(Classification.TransientError, "The external resource is not available"),
        CartesianProduct(Classification.ClientNotification, "This query builds a cartesian product between disconnected patterns."),
        PlannerUnsupportedWarning(Classification.ClientNotification, "This query is not supported by the COST planner."),
        RuntimeUnsupportedWarning(Classification.ClientNotification, "This query is not supported by the compiled runtime."),
        DeprecationWarning(Classification.ClientNotification, "This feature is deprecated and will be removed in future versions."),
        JoinHintUnfulfillableWarning(Classification.ClientNotification, "The database was unable to plan a hinted join."),
        JoinHintUnsupportedWarning(Classification.ClientNotification, "Queries with join hints are not supported by the RULE planner."),
        DynamicPropertyWarning(Classification.ClientNotification, "Queries using dynamic properties will use neither index seeks nor index scans for those properties"),
        EagerWarning(Classification.ClientNotification, "The execution plan for this query contains the Eager operator, which forces all dependent data to be materialized in main memory before proceeding"),
        IndexMissingWarning(Classification.ClientNotification, "Adding a schema index may speed up this query."),
        LabelMissingWarning(Classification.ClientNotification, "The provided label is not in the database."),
        RelTypeMissingWarning(Classification.ClientNotification, "The provided relationship type is not in the database."),
        PropertyNameMissingWarning(Classification.ClientNotification, "The provided property name is not in the database"),
        UnboundedPatternWarning(Classification.ClientNotification, "The provided pattern is unbounded, consider adding an upper limit to the number of node hops."),
        ExhaustiveShortestPathWarning(Classification.ClientNotification, "Exhaustive shortest path has been planned for your query that means that shortest path graph algorithm might not be used to find the shortest path.  Hence an exhaustive enumeration of all paths might be used in order to find the requested shortest path.");

        private final Code code;

        @Override
        public Code code() {
            return this.code;
        }

        private Statement(Classification classification, String description) {
            this.code = new Code(classification, this, description);
        }
    }

    public static enum Transaction implements Status
    {
        UnknownId(Classification.ClientError, "The request referred to a transaction that does not exist."),
        ConcurrentRequest(Classification.ClientError, "There were concurrent requests accessing the same transaction, which is not allowed."),
        CouldNotBegin(Classification.DatabaseError, "The database was unable to start the transaction."),
        CouldNotRollback(Classification.DatabaseError, "The database was unable to roll back the transaction."),
        CouldNotCommit(Classification.DatabaseError, "The database was unable to commit the transaction."),
        CouldNotWriteToLog(Classification.DatabaseError, "The database was unable to write transaction to log."),
        InvalidType(Classification.ClientError, "The transaction is of the wrong type to service the request. For instance, a transaction that has had schema modifications performed in it cannot be used to subsequently perform data operations, and vice versa."),
        ReleaseLocksFailed(Classification.DatabaseError, "The transaction was unable to release one or more of its locks."),
        AcquireLockTimeout(Classification.TransientError, "The transaction was unable to acquire a lock, for instance due to a timeout or the transaction thread being interrupted."),
        LockSessionInvalid(Classification.TransientError, "The lock session under which this transaction was started is no longer valid."),
        DeadlockDetected(Classification.TransientError, "This transaction, and at least one more transaction, has acquired locks in a way that it will wait indefinitely, and the database has aborted it. Retrying this transaction will most likely be successful."),
        Terminated(Classification.ClientError, "The current transaction has been marked as terminated, meaning no more interactions with it are allowed. There are several reasons this happens - the client might have asked for the transaction to be terminated, an operator might have asked for the database to be shut down, or the current instance is about to go through a cluster role switch. Simply retry your operation in a new transaction."),
        InstanceStateChanged(Classification.TransientError, "Transactions rely on assumptions around the state of the Neo4j instance they execute on. For instance, transactions in a cluster may expect that they are executing on an instance that can perform writes. However, instances may change state while the transaction is running. This causes assumptions the instance has made about how to execute the transaction to be violated - meaning the transaction must be rolled back. If you see this error, you should retry your operation in a new transaction."),
        EventHandlerThrewException(Classification.ClientError, "A transaction event handler threw an exception. The transaction will be rolled back."),
        ValidationFailed(Classification.ClientError, "Transaction changes did not pass validation checks"),
        ConstraintsChanged(Classification.TransientError, "Database constraints changed since the start of this transaction"),
        HookFailed(Classification.ClientError, "Transaction hook failure."),
        MarkedAsFailed(Classification.ClientError, "Transaction was marked as both successful and failed. Failure takes precedence and so this transaction was rolled back although it may have looked like it was going to be committed");

        private final Code code;

        @Override
        public Code code() {
            return this.code;
        }

        private Transaction(Classification classification, String description) {
            this.code = new Code(classification, this, description);
        }
    }

    public static enum Request implements Status
    {
        Invalid(Classification.ClientError, "The client provided an invalid request."),
        InvalidFormat(Classification.ClientError, "The client provided a request that was missing required fields, or had values that are not allowed."),
        NotInTransaction(Classification.ClientError, "The request cannot be performed outside of a transaction, and there is no transaction present to use. Wrap your request in a transaction and retry.");

        private final Code code;

        @Override
        public Code code() {
            return this.code;
        }

        private Request(Classification classification, String description) {
            this.code = new Code(classification, this, description);
        }
    }

    public static enum Network implements Status
    {
        UnknownFailure(Classification.TransientError, "An unknown network failure occurred, a retry may resolve the issue.");

        private final Code code;

        @Override
        public Code code() {
            return this.code;
        }

        private Network(Classification classification, String description) {
            this.code = new Code(classification, this, description);
        }
    }
}

