/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.function;

import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;

public final class Functions {
    private static Function IDENTITY = value -> value;
    public static Function<Object, String> TO_STRING = from -> {
        if (from != null) {
            return from.toString();
        }
        return "";
    };

    public static <From, To> Function<From, To> map(Map<From, To> map) {
        return map::get;
    }

    public static <From, To> Function<From, To> withDefaults(Function<From, To> defaults, Function<From, To> f) {
        return from -> {
            Object to = f.apply(from);
            if (to == null) {
                return defaults.apply(from);
            }
            return to;
        };
    }

    public static <From, To> Function<From, To> nullFunction() {
        return from -> null;
    }

    public static <From, To> Function<From, To> constant(To value) {
        return from -> value;
    }

    public static <T> Function<T, T> identity() {
        return IDENTITY;
    }

    public static <From, From2, To> BiFunction<? super Function<From, From2>, ? super Function<From2, To>, Function<From, To>> compose() {
        return (f1, f2) -> from -> f2.apply(f1.apply(from));
    }

    public static <T1, T2> BiFunction<? super BiFunction<T1, T2, T1>, ? super BiFunction<T1, T2, T1>, BiFunction<T1, T2, T1>> compose2() {
        return (function1, function2) -> (from1, from2) -> function1.apply(function2.apply(from1, from2), from2);
    }

    public static <FROM, TO> Function<FROM, TO> cast(final Class<TO> to) {
        return new Function<FROM, TO>(){

            @Override
            public TO apply(FROM from) {
                return to.cast(from);
            }

            public String toString() {
                return "cast(to=" + to.getName() + ")";
            }
        };
    }

    public static <T> Function<T, Void> fromConsumer(Consumer<T> consumer) {
        return t -> {
            consumer.accept(t);
            return null;
        };
    }
}

