/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.function;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.BooleanSupplier;
import java.util.function.IntPredicate;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import org.neo4j.function.Suppliers;

public class Predicates {
    private static final Predicate TRUE = item -> true;
    private static final Predicate FALSE = item -> false;
    private static final Predicate NOT_NULL = item -> item != null;
    public static IntPredicate ALWAYS_TRUE_INT = value -> true;

    public static <T> Predicate<T> alwaysTrue() {
        return TRUE;
    }

    public static <T> Predicate<T> alwaysFalse() {
        return FALSE;
    }

    public static <T> Predicate<T> notNull() {
        return NOT_NULL;
    }

    @SafeVarargs
    public static <T> Predicate<T> all(Predicate<T> ... predicates) {
        return Predicates.all(Arrays.asList(predicates));
    }

    public static <T> Predicate<T> all(Iterable<Predicate<T>> predicates) {
        return item -> {
            for (Predicate predicate : predicates) {
                if (predicate.test(item)) continue;
                return false;
            }
            return true;
        };
    }

    @SafeVarargs
    public static <T> Predicate<T> any(Predicate<T> ... predicates) {
        return Predicates.any(Arrays.asList(predicates));
    }

    public static <T> Predicate<T> any(Iterable<Predicate<T>> predicates) {
        return item -> {
            for (Predicate predicate : predicates) {
                if (!predicate.test(item)) continue;
                return true;
            }
            return false;
        };
    }

    public static <T> Predicate<T> instanceOf(@Nonnull Class clazz) {
        return item -> item != null && clazz.isInstance(item);
    }

    public static <T> Predicate<T> instanceOfAny(Class ... classes) {
        return item -> {
            if (item != null) {
                for (Class clazz : classes) {
                    if (!clazz.isInstance(item)) continue;
                    return true;
                }
            }
            return false;
        };
    }

    public static <T> Predicate<T> noDuplicates() {
        return new Predicate<T>(){
            private final Set<T> visitedItems = new HashSet();

            @Override
            public boolean test(T item) {
                return this.visitedItems.add(item);
            }
        };
    }

    public static <TYPE> void await(Supplier<TYPE> supplier, Predicate<TYPE> predicate, long timeout, TimeUnit unit) throws TimeoutException, InterruptedException {
        Predicates.await(Suppliers.compose(supplier, predicate), timeout, unit);
    }

    public static void await(Supplier<Boolean> condition, long timeout, TimeUnit unit) throws TimeoutException, InterruptedException {
        long sleep = Math.max(unit.toMillis(timeout) / 100L, 1L);
        long deadline = System.currentTimeMillis() + unit.toMillis(timeout);
        do {
            if (condition.get().booleanValue()) {
                return;
            }
            Thread.sleep(sleep);
        } while (System.currentTimeMillis() < deadline);
        throw new TimeoutException("Waited for " + timeout + " " + (Object)((Object)unit) + ", but " + condition + " was not accepted.");
    }

    public static void awaitForever(BooleanSupplier condition, long checkInterval, TimeUnit unit) throws InterruptedException {
        long sleep = unit.toMillis(checkInterval);
        while (!condition.getAsBoolean()) {
            Thread.sleep(sleep);
        }
        return;
    }

    public static <T> Predicate<T> in(T ... allowed) {
        return Predicates.in(Arrays.asList(allowed));
    }

    public static <T> Predicate<T> in(Iterable<T> allowed) {
        return item -> {
            for (Object allow : allowed) {
                if (!allow.equals(item)) continue;
                return true;
            }
            return false;
        };
    }
}

