/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.commandline;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Path;
import org.neo4j.cli.CommandFailedException;
import org.neo4j.io.fs.FileUtils;
import org.neo4j.logging.Level;
import org.neo4j.logging.log4j.Log4jLogProvider;

public final class Util {
    private Util() {
    }

    public static boolean isSameOrChildFile(Path parent, Path candidate) {
        Path canonicalCandidate = FileUtils.getCanonicalFile((Path)candidate);
        Path canonicalParentPath = FileUtils.getCanonicalFile((Path)parent);
        return canonicalCandidate.startsWith(canonicalParentPath);
    }

    public static void wrapIOException(IOException e) throws CommandFailedException {
        throw new CommandFailedException(String.format("Unable to load database: %s: %s", e.getClass().getSimpleName(), e.getMessage()), e);
    }

    public static Log4jLogProvider configuredLogProvider(OutputStream out, boolean verbose) {
        return new Log4jLogProvider(out, verbose ? Level.DEBUG : Level.INFO);
    }
}

