/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cli;

import java.io.PrintStream;
import java.nio.file.Path;
import java.util.Objects;
import org.neo4j.io.fs.DefaultFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.util.VisibleForTesting;

public class ExecutionContext {
    private final Path homeDir;
    private final Path confDir;
    private final PrintStream out;
    private final PrintStream err;
    private final FileSystemAbstraction fs;

    public ExecutionContext(Path homeDir, Path confDir) {
        this(homeDir, confDir, System.out, System.err, (FileSystemAbstraction)new DefaultFileSystemAbstraction());
    }

    @VisibleForTesting
    public ExecutionContext(Path homeDir, Path confDir, PrintStream out, PrintStream err, FileSystemAbstraction fs) {
        this.homeDir = Objects.requireNonNull(homeDir);
        this.confDir = Objects.requireNonNull(confDir);
        this.out = Objects.requireNonNull(out);
        this.err = Objects.requireNonNull(err);
        this.fs = Objects.requireNonNull(fs);
    }

    public PrintStream out() {
        return this.out;
    }

    public PrintStream err() {
        return this.err;
    }

    public FileSystemAbstraction fs() {
        return this.fs;
    }

    public Path homeDir() {
        return this.homeDir;
    }

    public Path confDir() {
        return this.confDir;
    }
}

