/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cli;

import java.io.PrintWriter;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collection;
import org.apache.commons.lang3.StringUtils;
import org.neo4j.cli.CommandProvider;
import org.neo4j.cli.ExecutionContext;
import org.neo4j.internal.unsafe.UnsafeUtil;
import org.neo4j.kernel.internal.Version;
import org.neo4j.service.Services;
import org.neo4j.util.VisibleForTesting;
import picocli.CommandLine;

@CommandLine.Command(name="neo4j-admin", description={"Neo4j database administration tool."}, mixinStandardHelpOptions=true, versionProvider=VersionProvider.class, footerHeading="\nEnvironment variables:\n", footer={"  NEO4J_CONF    Path to directory which contains neo4j.conf.", "  NEO4J_DEBUG   Set to anything to enable debug output.", "  NEO4J_HOME    Neo4j home directory.", "  HEAP_SIZE     Set JVM maximum heap size during command execution. Takes a number and a unit, for example 512m."})
public final class AdminTool {
    private AdminTool() {
    }

    public static void main(String[] args) {
        UnsafeUtil.disableIllegalAccessLogger();
        Path homeDir = AdminTool.getDirOrExit("NEO4J_HOME");
        Path confDir = AdminTool.getDirOrExit("NEO4J_CONF");
        ExecutionContext ctx = new ExecutionContext(homeDir, confDir);
        int exitCode = AdminTool.execute(ctx, args);
        System.exit(exitCode);
    }

    @VisibleForTesting
    public static int execute(ExecutionContext ctx, String ... args) {
        PrintWriter out = new PrintWriter(ctx.out(), true);
        CommandLine cmd = new CommandLine((Object)new AdminTool()).setOut(out).setErr(new PrintWriter(ctx.err(), true)).setUsageHelpWidth(120).setCaseInsensitiveEnumValuesAllowed(true);
        AdminTool.registerCommands(cmd, ctx);
        if (args.length == 0) {
            cmd.usage(out);
            return 2;
        }
        return cmd.execute(args);
    }

    private static void registerCommands(CommandLine cmd, ExecutionContext ctx) {
        cmd.addSubcommand(CommandLine.HelpCommand.class);
        Collection providers = Services.loadAll(CommandProvider.class);
        for (CommandProvider provider : providers) {
            cmd.addSubcommand(provider.createCommand(ctx));
        }
    }

    private static Path getDirOrExit(String envVar) {
        Path path;
        String value = System.getenv(envVar);
        if (StringUtils.isBlank((CharSequence)value)) {
            System.err.printf("Required environment variable '%s' is not set%n", envVar);
            System.exit(2);
        }
        if (!Files.isDirectory(path = Path.of(value, new String[0]).toAbsolutePath(), new LinkOption[0])) {
            System.err.printf("%s path doesn't exist or not a directory: %s%n", envVar, path);
            System.exit(2);
        }
        return path;
    }

    static class VersionProvider
    implements CommandLine.IVersionProvider {
        VersionProvider() {
        }

        public String[] getVersion() {
            return new String[]{Version.getNeo4jVersion()};
        }
    }
}

