/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.commandline;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.neo4j.commandline.admin.CommandFailed;
import org.neo4j.io.fs.DefaultFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.StoreLockException;
import org.neo4j.kernel.internal.StoreLocker;

public class Util {
    public static Path canonicalPath(Path path) throws IllegalArgumentException {
        return Util.canonicalPath(path.toFile());
    }

    public static Path canonicalPath(String path) throws IllegalArgumentException {
        return Util.canonicalPath(new File(path));
    }

    public static Path canonicalPath(File file) throws IllegalArgumentException {
        try {
            return Paths.get(file.getCanonicalPath(), new String[0]);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Unable to parse path: " + file, e);
        }
    }

    public static void checkLock(Path databaseDirectory) throws CommandFailed {
        try (DefaultFileSystemAbstraction fileSystem = new DefaultFileSystemAbstraction();
             StoreLocker storeLocker = new StoreLocker((FileSystemAbstraction)fileSystem);){
            storeLocker.checkLock(databaseDirectory.toFile());
        }
        catch (StoreLockException e) {
            throw new CommandFailed("the database is in use -- stop Neo4j and try again", (Exception)((Object)e));
        }
        catch (IOException e) {
            Util.wrapIOException(e);
        }
    }

    public static void wrapIOException(IOException e) throws CommandFailed {
        throw new CommandFailed(String.format("unable to load database: %s: %s", e.getClass().getSimpleName(), e.getMessage()), e);
    }
}

