/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.commandline.arguments;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.text.WordUtils;
import org.neo4j.commandline.arguments.MandatoryPositionalArgument;
import org.neo4j.commandline.arguments.NamedArgument;
import org.neo4j.commandline.arguments.OptionalNamedArg;
import org.neo4j.commandline.arguments.OptionalPositionalArgument;
import org.neo4j.commandline.arguments.PositionalArgument;
import org.neo4j.commandline.arguments.common.Database;
import org.neo4j.commandline.arguments.common.MandatoryCanonicalPath;
import org.neo4j.commandline.arguments.common.OptionalCanonicalPath;

public class Arguments {
    public static final Arguments NO_ARGS = new Arguments();
    private static final int LINE_LENGTH = 80;
    private static final int MIN_RIGHT_COL_WIDTH = 30;
    private static final String NEWLINE = System.getProperty("line.separator");
    private final Map<String, NamedArgument> namedArgs = new LinkedHashMap<String, NamedArgument>();
    private final ArrayList<PositionalArgument> positionalArgs = new ArrayList();

    public Arguments withDatabase() {
        return this.withArgument(new Database());
    }

    public Arguments withAdditionalConfig() {
        return this.withArgument(new OptionalCanonicalPath("additional-config", "config-file-path", "", "Configuration file to supply additional configuration in."));
    }

    public Arguments withTo(String description) {
        return this.withArgument(new MandatoryCanonicalPath("to", "destination-path", description));
    }

    public Arguments withOptionalPositionalArgument(int position, String value) {
        return this.withPositionalArgument(new OptionalPositionalArgument(position, value));
    }

    public Arguments withMandatoryPositionalArgument(int position, String value) {
        return this.withPositionalArgument(new MandatoryPositionalArgument(position, value));
    }

    public Arguments withArgument(NamedArgument namedArgument) {
        this.namedArgs.put(namedArgument.name(), namedArgument);
        return this;
    }

    public Arguments withPositionalArgument(PositionalArgument arg) {
        this.positionalArgs.add(arg);
        return this;
    }

    public String usage() {
        StringBuilder sb = new StringBuilder();
        if (!this.namedArgs.isEmpty()) {
            sb.append(this.namedArgs.values().stream().map(NamedArgument::usage).collect(Collectors.joining(" ")));
        }
        if (!this.positionalArgs.isEmpty()) {
            sb.append(" ");
            this.positionalArgs.sort((l, r) -> Integer.compare(l.position(), r.position()));
            sb.append(this.positionalArgs.stream().map(a -> a.usage()).collect(Collectors.joining(" ")));
        }
        return sb.toString().trim();
    }

    public String description(String text) {
        String wrappedText = Arguments.wrapText(text, 80);
        if (this.namedArgs.isEmpty()) {
            return wrappedText;
        }
        wrappedText = String.join((CharSequence)(NEWLINE + NEWLINE), wrappedText, "options:");
        int alignLength = this.namedArgs.values().stream().map(a -> a.optionsListing().length()).reduce(0, Integer::max);
        return String.join((CharSequence)NEWLINE, wrappedText, this.namedArgs.values().stream().map(c -> this.formatArgumentDescription(alignLength, (NamedArgument)c)).collect(Collectors.joining(NEWLINE)));
    }

    public static String wrapText(String text, int lineLength) {
        List<String> lines = Arrays.asList(text.split("\r?\n"));
        return lines.stream().map(l -> WordUtils.wrap((String)l, (int)lineLength)).collect(Collectors.joining(NEWLINE));
    }

    public String formatArgumentDescription(int longestAlignmentLength, NamedArgument argument) {
        String left = String.format("  %s", argument.optionsListing());
        String right = argument instanceof OptionalNamedArg ? String.format("%s [default:%s]", argument.description(), ((OptionalNamedArg)argument).defaultValue()) : argument.description();
        return Arguments.rightColumnFormatted(left, right, longestAlignmentLength + 5);
    }

    public static String rightColumnFormatted(String leftText, String rightText, int rightAlignIndex) {
        int newLineIndent = 6;
        int rightWidth = 80 - rightAlignIndex;
        boolean startOnNewLine = false;
        if (rightWidth < 30) {
            startOnNewLine = true;
            rightWidth = 74;
        }
        String[] rightLines = Arguments.wrapText(rightText, rightWidth).split(NEWLINE);
        String fmt = "%-" + (startOnNewLine ? 6 : rightAlignIndex) + "s%s";
        String firstLine = String.format(fmt, leftText, startOnNewLine ? "" : rightLines[0]);
        String rest = Arrays.stream(rightLines).skip(startOnNewLine ? 0L : 1L).map(l -> String.format(fmt, "", l)).collect(Collectors.joining(NEWLINE));
        if (rest.isEmpty()) {
            return firstLine;
        }
        return String.join((CharSequence)NEWLINE, firstLine, rest);
    }

    public String parse(String argName, String[] args) {
        if (this.namedArgs.containsKey(argName)) {
            return this.namedArgs.get(argName).parse(args);
        }
        throw new IllegalArgumentException("No such argument available to be parsed: " + argName);
    }

    public boolean parseBoolean(String argName, String[] args) {
        return this.parse(argName, Boolean::parseBoolean, args);
    }

    public Optional<Path> parseOptionalPath(String argName, String[] args) {
        String p = this.parse(argName, args);
        if (p.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(Paths.get(p, new String[0]));
    }

    public Path parseMandatoryPath(String argName, String[] args) {
        Optional<Path> p = this.parseOptionalPath(argName, args);
        if (p.isPresent()) {
            return p.get();
        }
        throw new IllegalArgumentException(String.format("Missing exampleValue for '%s'", argName));
    }

    public <T> T parse(String argName, Function<String, T> converter, String[] args) {
        return converter.apply(this.parse(argName, args));
    }
}

