/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cli;

import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.time.Duration;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.spi.ExtendedLogger;
import org.eclipse.collections.api.set.MutableSet;
import org.eclipse.collections.impl.set.mutable.MutableSetFactoryImpl;
import org.neo4j.cli.AbstractCommand;
import org.neo4j.cli.CommandFailedException;
import org.neo4j.cli.ExecutionContext;
import org.neo4j.cloud.storage.StoragePath;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.configuration.connectors.BoltConnector;
import org.neo4j.configuration.connectors.HttpConnector;
import org.neo4j.configuration.connectors.HttpsConnector;
import org.neo4j.configuration.helpers.DatabaseNamePattern;
import org.neo4j.graphdb.config.Configuration;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.layout.Neo4jLayout;
import org.neo4j.kernel.diagnostics.providers.SystemDiagnostics;
import org.neo4j.kernel.internal.Version;
import org.neo4j.logging.Level;
import org.neo4j.logging.log4j.LogConfig;
import org.neo4j.logging.log4j.Neo4jLoggerContext;
import org.neo4j.time.Stopwatch;
import picocli.CommandLine;

public abstract class AbstractAdminCommand
extends AbstractCommand {
    public static final String COMMAND_CONFIG_FILE_NAME_PATTERN = "neo4j-admin-%s.conf";
    public static final String ADMIN_CONFIG_FILE_NAME = "neo4j-admin.conf";
    public static final String CRASH_INFO_TIMEOUT = "NEO4J_ADMIN_CRASH_INFO_DUMP_TIMEOUT_SECONDS";
    private static final DateTimeFormatter SPACELESS_DATE_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd.HH.mm.ss").withZone(ZoneId.systemDefault());
    private static final String EXCEPTION_FILE_NAME_TEMPLATE = "neo4j-admin-exception-trace-%s.log";
    @CommandLine.Option(names={"--additional-config"}, paramLabel="<file>", description={"Configuration file with additional configuration."})
    private Path additionalConfig;

    protected AbstractAdminCommand(ExecutionContext ctx) {
        super(ctx);
    }

    public List<Path> getCommandConfigs() throws IllegalArgumentException {
        ArrayList<Path> configs = new ArrayList<Path>(3);
        if (this.additionalConfig != null) {
            if (!this.configFileExists(this.additionalConfig)) {
                throw new CommandFailedException(String.format("File %s does not exist", this.additionalConfig));
            }
            configs.add(this.additionalConfig);
        }
        this.commandConfigName().map(configName -> String.format(COMMAND_CONFIG_FILE_NAME_PATTERN, configName)).map(this.ctx.confDir()::resolve).filter(this::configFileExists).ifPresent(configs::add);
        Path adminConfig = this.ctx.confDir().resolve(ADMIN_CONFIG_FILE_NAME);
        if (this.configFileExists(adminConfig)) {
            configs.add(adminConfig);
        }
        return configs;
    }

    @Override
    protected List<Path> configFiles() {
        List<Path> commandConfigs = this.getCommandConfigs();
        commandConfigs.addAll(super.configFiles());
        return commandConfigs;
    }

    private boolean configFileExists(Path path) {
        return this.ctx.fs().fileExists(path) && !this.ctx.fs().isDirectory(path);
    }

    protected Optional<String> commandConfigName() {
        return Optional.empty();
    }

    protected Config.Builder createPrefilledConfigBuilder() {
        List<Path> commandConfigs = this.getCommandConfigs();
        Config.Builder configBuilder = Config.newBuilder().fromFileNoThrow(this.ctx.confDir().resolve("neo4j.conf"));
        commandConfigs.reversed().forEach(arg_0 -> ((Config.Builder)configBuilder).fromFileNoThrow(arg_0));
        configBuilder.commandExpansion(this.allowCommandExpansion).set(GraphDatabaseSettings.neo4j_home, (Object)this.ctx.homeDir());
        configBuilder.set(BoltConnector.enabled, (Object)Boolean.FALSE);
        configBuilder.set(HttpConnector.enabled, (Object)Boolean.FALSE);
        configBuilder.set(HttpsConnector.enabled, (Object)Boolean.FALSE);
        return configBuilder;
    }

    protected Path requireExisting(Path p) {
        try {
            return p.toRealPath(new LinkOption[0]);
        }
        catch (IOException e) {
            throw new CommandFailedException(String.format("Path '%s' does not exist.", p), e);
        }
    }

    protected Path normalizeAndValidateIfStoragePathDirectory(Path path) throws CommandFailedException {
        StoragePath storagePath;
        Path normalized = path.normalize();
        if (normalized instanceof StoragePath && !(storagePath = (StoragePath)normalized).isDirectory()) {
            throw new CommandFailedException("The path '%s' is not a directory - please add a terminal '/' to your path".formatted(storagePath.toUri()));
        }
        return normalized;
    }

    protected static Set<String> getDbNames(Config config, FileSystemAbstraction fs, DatabaseNamePattern database) throws CommandFailedException {
        if (!database.containsPattern()) {
            return Set.of(database.getDatabaseName());
        }
        MutableSet dbNames = MutableSetFactoryImpl.INSTANCE.empty();
        Path databasesDir = Neo4jLayout.of((Configuration)config).databasesDirectory();
        try {
            for (Path path : fs.listFiles(databasesDir)) {
                String name;
                if (!fs.isDirectory(path) || !database.matches(name = path.getFileName().toString())) continue;
                dbNames.add(name);
            }
        }
        catch (IOException e) {
            throw new CommandFailedException(String.format("Failed to list databases: %s: %s", e.getClass().getSimpleName(), e.getMessage()), e);
        }
        if (dbNames.isEmpty()) {
            throw new CommandFailedException("Pattern '" + database.getDatabaseName() + "' did not match any database");
        }
        return dbNames;
    }

    @Override
    protected void wrappedExecute() throws Exception {
        Stopwatch start = Stopwatch.start();
        try {
            this.execute();
        }
        catch (Throwable ex) {
            this.logCrashInformation(ex, start.elapsed());
            throw ex;
        }
    }

    protected void println(String message) {
        this.ctx.out().println(message);
    }

    protected void printf(String message, Object ... args) {
        this.ctx.out().printf(message, args);
    }

    private void logCrashInformation(Throwable ex, Duration elapsed) {
        try {
            int timeout = Integer.parseInt(System.getenv().getOrDefault(CRASH_INFO_TIMEOUT, "3"));
            if (!this.verbose && elapsed.toMillis() < TimeUnit.SECONDS.toMillis(timeout)) {
                return;
            }
            Config config = this.createPrefilledConfigBuilder().build();
            Path exceptionFile = ((Path)config.get(GraphDatabaseSettings.logs_directory)).resolve(String.format(EXCEPTION_FILE_NAME_TEMPLATE, SPACELESS_DATE_FORMATTER.format(Instant.now())));
            this.ctx.fs().mkdirs(exceptionFile.getParent());
            try (Neo4jLoggerContext exceptionLoggerCtx = LogConfig.createTemporaryLoggerToSingleFile((FileSystemAbstraction)this.ctx.fs(), (Path)exceptionFile, (Level)Level.INFO, (boolean)false);){
                ExtendedLogger exceptionLogger = exceptionLoggerCtx.getLogger(this.getClass());
                exceptionLogger.info("This file is to aid Neo4j support.");
                exceptionLogger.error("Fatal exception thrown", ex);
                this.ctx.err().println("Full exception details written to: " + String.valueOf(exceptionFile));
                this.ctx.err().println("Please provide this file if requesting neo4j support");
                RuntimeMXBean runtime = ManagementFactory.getRuntimeMXBean();
                exceptionLogger.info("Process Started at: " + String.valueOf(Instant.ofEpochMilli(runtime.getStartTime())));
                String originalArgs = String.join((CharSequence)" ", this.spec.root().commandLine().getParseResult().originalArgs());
                exceptionLogger.info("CommandLine: " + originalArgs);
                exceptionLogger.info("neo4j version: " + Version.getNeo4jVersion());
                SystemDiagnostics.JAVA_VIRTUAL_MACHINE.dump(arg_0 -> ((ExtendedLogger)exceptionLogger).info(arg_0));
                SystemDiagnostics.CLASSPATH.dump(arg_0 -> ((ExtendedLogger)exceptionLogger).info(arg_0));
                SystemDiagnostics.OPERATING_SYSTEM.dump(arg_0 -> ((ExtendedLogger)exceptionLogger).info(arg_0));
                SystemDiagnostics.SYSTEM_MEMORY.dump(arg_0 -> ((ExtendedLogger)exceptionLogger).info(arg_0));
                SystemDiagnostics.JAVA_MEMORY.dump(arg_0 -> ((ExtendedLogger)exceptionLogger).info(arg_0));
                exceptionLogger.info("Configuration files used (ordered by priority):");
                this.configFiles().forEach(file -> exceptionLogger.info((Object)file.toAbsolutePath()));
            }
        }
        catch (Throwable e) {
            ex.addSuppressed(e);
        }
    }
}

