/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.codegen;

import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.neo4j.codegen.Parameter;
import org.neo4j.codegen.TypeReference;

public abstract class MethodDeclaration {
    private final TypeReference owner;
    private final Parameter[] parameters;
    private final TypeReference[] exceptions;
    private final TypeParameter[] typeParameters;
    private final int modifiers;

    public static Builder method(Class<?> returnType, String name, Parameter ... parameters) {
        return MethodDeclaration.method(TypeReference.typeReference(returnType), name, parameters);
    }

    public static Builder method(final TypeReference returnType, final String name, Parameter ... parameters) {
        return new Builder(parameters){

            @Override
            MethodDeclaration build(TypeReference owner) {
                return MethodDeclaration.method(owner, returnType, name, this.parameters, this.exceptions(), this.modifiers(), this.typeParameters());
            }
        };
    }

    static Builder constructor(Parameter ... parameters) {
        return new Builder(parameters){

            @Override
            MethodDeclaration build(TypeReference owner) {
                return MethodDeclaration.constructor(owner, this.parameters, this.exceptions(), this.modifiers(), this.typeParameters());
            }
        };
    }

    public List<TypeParameter> typeParameters() {
        return Collections.unmodifiableList(Arrays.asList(this.typeParameters));
    }

    public List<TypeReference> throwsList() {
        return Collections.unmodifiableList(Arrays.asList(this.exceptions));
    }

    MethodDeclaration(TypeReference owner, Parameter[] parameters, TypeReference[] exceptions, int modifiers, TypeParameter[] typeParameters) {
        this.owner = owner;
        this.parameters = parameters;
        this.exceptions = exceptions;
        this.modifiers = modifiers;
        this.typeParameters = typeParameters;
    }

    public abstract boolean isConstructor();

    public boolean isStatic() {
        return Modifier.isStatic(this.modifiers);
    }

    public boolean isGeneric() {
        if (this.returnType().isGeneric() || this.typeParameters.length != 0) {
            return true;
        }
        for (Parameter parameter : this.parameters) {
            if (!parameter.type().isGeneric()) continue;
            return true;
        }
        return false;
    }

    public TypeReference declaringClass() {
        return this.owner;
    }

    public int modifiers() {
        return this.modifiers;
    }

    public abstract TypeReference returnType();

    public abstract String name();

    public Parameter[] parameters() {
        return this.parameters;
    }

    /*
     * WARNING - void declaration
     */
    public MethodDeclaration erased() {
        void var5_11;
        HashMap<String, TypeReference> table = new HashMap<String, TypeReference>();
        for (TypeParameter typeParameter : this.typeParameters) {
            table.put(typeParameter.name(), typeParameter.extendsBound());
        }
        TypeReference newReturnType = MethodDeclaration.erase(this.returnType(), table);
        Parameter[] newParameters = new Parameter[this.parameters.length];
        for (int i = 0; i < this.parameters.length; ++i) {
            Parameter parameter = this.parameters[i];
            TypeReference erasedType = MethodDeclaration.erase(parameter.type(), table);
            newParameters[i] = Parameter.param(erasedType, parameter.name());
        }
        TypeReference[] newExceptions = new TypeReference[this.exceptions.length];
        boolean bl = false;
        while (var5_11 < this.exceptions.length) {
            newExceptions[var5_11] = MethodDeclaration.erase(this.exceptions[var5_11], table);
            ++var5_11;
        }
        String string = this.name();
        boolean newIsConstructor = this.isConstructor();
        return MethodDeclaration.methodDeclaration(this.owner, newReturnType, newParameters, newExceptions, string, newIsConstructor, this.modifiers, this.typeParameters);
    }

    private static TypeReference erase(TypeReference reference, Map<String, TypeReference> table) {
        TypeReference erasedReference = table.get(reference.fullName());
        return erasedReference != null ? erasedReference : reference;
    }

    static MethodDeclaration method(TypeReference owner, TypeReference returnType, String name, Parameter[] parameters, TypeReference[] exceptions, int modifiers, TypeParameter[] typeParameters) {
        return MethodDeclaration.methodDeclaration(owner, returnType, parameters, exceptions, name, false, modifiers, typeParameters);
    }

    static MethodDeclaration constructor(TypeReference owner, Parameter[] parameters, TypeReference[] exceptions, int modifiers, TypeParameter[] typeParameters) {
        return MethodDeclaration.methodDeclaration(owner, TypeReference.VOID, parameters, exceptions, "<init>", true, modifiers, typeParameters);
    }

    private static MethodDeclaration methodDeclaration(TypeReference owner, final TypeReference returnType, Parameter[] parameters, TypeReference[] exceptions, final String name, final boolean isConstructor, int modifiers, TypeParameter[] typeParameters) {
        return new MethodDeclaration(owner, parameters, exceptions, modifiers, typeParameters){

            @Override
            public boolean isConstructor() {
                return isConstructor;
            }

            @Override
            public TypeReference returnType() {
                return returnType;
            }

            @Override
            public String name() {
                return name;
            }
        };
    }

    public static abstract class Builder {
        private LinkedHashMap<String, TypeReference.Bound> typeParameters;
        final Parameter[] parameters;
        private List<TypeReference> exceptions;
        private int modifiers = 1;

        public Builder parameterizedWith(String name, TypeReference.Bound bound) {
            if (this.typeParameters == null) {
                this.typeParameters = new LinkedHashMap();
            } else if (this.typeParameters.containsKey(name)) {
                throw new IllegalArgumentException(name + " defined twice");
            }
            this.typeParameters.put(name, bound);
            return this;
        }

        public Builder throwsException(Class<?> type) {
            return this.throwsException(TypeReference.typeReference(type));
        }

        public Builder throwsException(TypeReference type) {
            if (this.exceptions == null) {
                this.exceptions = new ArrayList<TypeReference>();
            }
            this.exceptions.add(type);
            return this;
        }

        public Builder modifiers(int modifiers) {
            this.modifiers = modifiers;
            return this;
        }

        public int modifiers() {
            return this.modifiers;
        }

        abstract MethodDeclaration build(TypeReference var1);

        private Builder(Parameter[] parameters) {
            this.parameters = parameters;
        }

        TypeReference[] exceptions() {
            return this.exceptions == null ? TypeReference.NO_TYPES : this.exceptions.toArray(new TypeReference[0]);
        }

        TypeParameter[] typeParameters() {
            if (this.typeParameters == null) {
                return TypeParameter.NO_PARAMETERS;
            }
            TypeParameter[] result = new TypeParameter[this.typeParameters.size()];
            int i = 0;
            for (Map.Entry<String, TypeReference.Bound> entry : this.typeParameters.entrySet()) {
                result[i++] = new TypeParameter(entry.getKey(), entry.getValue());
            }
            return result;
        }
    }

    public static class TypeParameter {
        static final TypeParameter[] NO_PARAMETERS = new TypeParameter[0];
        final String name;
        final TypeReference.Bound bound;

        TypeParameter(String name, TypeReference.Bound bound) {
            this.name = name;
            this.bound = bound;
        }

        public String name() {
            return this.name;
        }

        public TypeReference extendsBound() {
            return this.bound.extendsBound();
        }

        public TypeReference superBound() {
            return this.bound.superBound();
        }
    }
}

