/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.codegen;

import java.lang.invoke.MethodHandles;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import org.neo4j.codegen.ByteCodeVisitor;
import org.neo4j.codegen.ByteCodes;

class CodeLoader
extends ClassLoader {
    private final Map<String, ByteCodes> stagedClasses = new HashMap<String, ByteCodes>();
    private static final MethodHandles.Lookup LOOKUP;

    CodeLoader(ClassLoader parent) {
        super(parent);
    }

    synchronized void stageForLoading(Iterable<? extends ByteCodes> classes, ByteCodeVisitor visitor) {
        for (ByteCodes byteCodes : classes) {
            visitor.visitByteCode(byteCodes.name(), byteCodes.bytes().duplicate());
            this.stagedClasses.put(byteCodes.name(), byteCodes);
        }
    }

    @Override
    protected synchronized Class<?> findClass(String name) throws ClassNotFoundException {
        ByteCodes clazz = this.stagedClasses.remove(name);
        if (clazz == null) {
            throw new ClassNotFoundException(name);
        }
        String packageName = name.substring(0, name.lastIndexOf(46));
        if (this.getDefinedPackage(packageName) == null) {
            this.definePackage(packageName, "", "", "", "", "", "", null);
        }
        return this.defineClass(name, clazz.bytes(), null);
    }

    protected synchronized Class<?> defineHiddenClass(String name) throws Throwable {
        ByteCodes clazz = this.stagedClasses.remove(name);
        if (clazz == null) {
            throw new ClassNotFoundException(name);
        }
        return LOOKUP.defineHiddenClass(CodeLoader.classBytes(clazz), true, MethodHandles.Lookup.ClassOption.NESTMATE).lookupClass();
    }

    private static byte[] classBytes(ByteCodes clazz) {
        byte[] bytes;
        ByteBuffer byteBuffer = clazz.bytes();
        if (byteBuffer.hasArray()) {
            bytes = byteBuffer.array();
        } else {
            bytes = new byte[byteBuffer.remaining()];
            byteBuffer.get(bytes);
        }
        return bytes;
    }

    static {
        try {
            LOOKUP = MethodHandles.privateLookupIn(CodeLoader.class, MethodHandles.lookup());
        }
        catch (IllegalAccessException e) {
            throw new ExceptionInInitializerError(e);
        }
    }
}

