/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.codegen;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import org.neo4j.util.Preconditions;
import org.neo4j.values.AnyValue;

public class TypeReference {
    private final String packageName;
    private final String name;
    private final TypeReference[] parameters;
    private final int arrayDepth;
    private final boolean isTypeParameter;
    private final TypeReference declaringClass;
    private final int modifiers;
    public static final TypeReference VOID = new TypeReference("", "void", 0, false, null, Void.TYPE.getModifiers(), new TypeReference[0]);
    public static final TypeReference OBJECT = new TypeReference("java.lang", "Object", 0, false, null, Object.class.getModifiers(), new TypeReference[0]);
    public static final TypeReference BOOLEAN = new TypeReference("", "boolean", 0, false, null, Boolean.TYPE.getModifiers(), new TypeReference[0]);
    public static final TypeReference INT = new TypeReference("", "int", 0, false, null, Integer.TYPE.getModifiers(), new TypeReference[0]);
    public static final TypeReference LONG = new TypeReference("", "long", 0, false, null, Long.TYPE.getModifiers(), new TypeReference[0]);
    public static final TypeReference DOUBLE = new TypeReference("", "double", 0, false, null, Double.TYPE.getModifiers(), new TypeReference[0]);
    public static final TypeReference BOOLEAN_ARRAY = new TypeReference("", "boolean", 1, false, null, Boolean.TYPE.getModifiers(), new TypeReference[0]);
    public static final TypeReference INT_ARRAY = new TypeReference("", "int", 1, false, null, Integer.TYPE.getModifiers(), new TypeReference[0]);
    public static final TypeReference LONG_ARRAY = new TypeReference("", "long", 1, false, null, Long.TYPE.getModifiers(), new TypeReference[0]);
    public static final TypeReference DOUBLE_ARRAY = new TypeReference("", "double", 1, false, null, Double.TYPE.getModifiers(), new TypeReference[0]);
    public static final TypeReference VALUE = new TypeReference("org.neo4j.values", "AnyValue", 0, false, null, AnyValue.class.getModifiers(), new TypeReference[0]);
    static final TypeReference[] NO_TYPES = new TypeReference[0];

    public static Bound extending(Class<?> type) {
        return TypeReference.extending(TypeReference.typeReference(type));
    }

    public static Bound extending(final TypeReference type) {
        return new Bound(type){

            @Override
            public TypeReference extendsBound() {
                return type;
            }

            @Override
            public TypeReference superBound() {
                return null;
            }
        };
    }

    private static TypeReference primitiveType(Class<?> base) {
        return new TypeReference("", base.getSimpleName(), 0, false, null, base.getModifiers(), new TypeReference[0]);
    }

    private static TypeReference primitiveArray(Class<?> base, int arrayDepth) {
        assert (base.isPrimitive());
        return new TypeReference("", base.getSimpleName(), arrayDepth, false, null, base.getModifiers(), new TypeReference[0]);
    }

    public static TypeReference typeReference(Class<?> type) {
        Class<?> declaringClass;
        if (type == Void.TYPE) {
            return VOID;
        }
        if (type == Object.class) {
            return OBJECT;
        }
        Class<?> innerType = type;
        int arrayDepth = 0;
        while (innerType.isArray()) {
            innerType = innerType.getComponentType();
            ++arrayDepth;
        }
        if (innerType.isPrimitive()) {
            return arrayDepth > 0 ? TypeReference.primitiveArray(innerType, arrayDepth) : TypeReference.primitiveType(innerType);
        }
        String packageName = "";
        TypeReference declaringTypeReference = null;
        Package typePackage = innerType.getPackage();
        if (typePackage != null) {
            packageName = typePackage.getName();
        }
        if ((declaringClass = innerType.getDeclaringClass()) != null) {
            declaringTypeReference = TypeReference.typeReference(declaringClass);
        }
        String name = innerType.getSimpleName();
        return new TypeReference(packageName, name, arrayDepth, false, declaringTypeReference, type.getModifiers(), new TypeReference[0]);
    }

    public static TypeReference typeParameter(String name) {
        return new TypeReference("", name, 0, true, null, 1, new TypeReference[0]);
    }

    public static TypeReference arrayOf(TypeReference type) {
        return new TypeReference(type.packageName, type.name, type.arrayDepth + 1, false, type.declaringClass, type.modifiers, new TypeReference[0]);
    }

    public static TypeReference parameterizedType(Class<?> base, Class<?> ... parameters) {
        return TypeReference.parameterizedType(TypeReference.typeReference(base), TypeReference.typeReferences(parameters));
    }

    public static TypeReference parameterizedType(Class<?> base, TypeReference ... parameters) {
        return TypeReference.parameterizedType(TypeReference.typeReference(base), parameters);
    }

    public static TypeReference parameterizedType(TypeReference base, TypeReference ... parameters) {
        return new TypeReference(base.packageName, base.name, base.arrayDepth, false, base.declaringClass, base.modifiers, parameters);
    }

    public static TypeReference[] typeReferences(Class<?> first, Class<?>[] more) {
        TypeReference[] result = new TypeReference[more.length + 1];
        result[0] = TypeReference.typeReference(first);
        for (int i = 0; i < more.length; ++i) {
            result[i + 1] = TypeReference.typeReference(more[i]);
        }
        return result;
    }

    public static TypeReference[] typeReferences(Class<?>[] types) {
        TypeReference[] result = new TypeReference[types.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = TypeReference.typeReference(types[i]);
        }
        return result;
    }

    public static TypeReference toBoxedType(TypeReference in) {
        switch (in.fullName()) {
            case "byte": {
                return TypeReference.typeReference(Byte.class);
            }
            case "short": {
                return TypeReference.typeReference(Short.class);
            }
            case "int": {
                return TypeReference.typeReference(Integer.class);
            }
            case "long": {
                return TypeReference.typeReference(Long.class);
            }
            case "char": {
                return TypeReference.typeReference(Character.class);
            }
            case "boolean": {
                return TypeReference.typeReference(Boolean.class);
            }
            case "float": {
                return TypeReference.typeReference(Float.class);
            }
            case "double": {
                return TypeReference.typeReference(Double.class);
            }
        }
        return in;
    }

    public static TypeReference toUnboxedType(TypeReference in) {
        if (in.isPrimitive()) {
            return in;
        }
        switch (in.fullName()) {
            case "java.lang.Byte": {
                return TypeReference.typeReference(Byte.TYPE);
            }
            case "java.lang.Short": {
                return TypeReference.typeReference(Short.TYPE);
            }
            case "java.lang.Integer": {
                return TypeReference.typeReference(Integer.TYPE);
            }
            case "java.lang.Long": {
                return TypeReference.typeReference(Long.TYPE);
            }
            case "java.lang.Character": {
                return TypeReference.typeReference(Character.TYPE);
            }
            case "java.lang.Boolean": {
                return TypeReference.typeReference(Boolean.TYPE);
            }
            case "java.lang.Float": {
                return TypeReference.typeReference(Float.TYPE);
            }
            case "java.lang.Double": {
                return TypeReference.typeReference(Double.TYPE);
            }
        }
        throw new IllegalStateException("Cannot unbox " + in.fullName());
    }

    TypeReference(String packageName, String name, int arrayDepth, boolean isTypeParameter, TypeReference declaringClass, int modifiers, TypeReference ... parameters) {
        this.packageName = packageName;
        this.name = name;
        this.arrayDepth = arrayDepth;
        this.isTypeParameter = isTypeParameter;
        this.declaringClass = declaringClass;
        this.modifiers = modifiers;
        this.parameters = parameters;
    }

    public String packageName() {
        return this.packageName;
    }

    public String name() {
        return this.name;
    }

    public String simpleName() {
        StringBuilder builder = new StringBuilder(this.name);
        builder.append("[]".repeat(Math.max(0, this.arrayDepth)));
        return builder.toString();
    }

    public boolean isPrimitive() {
        if (this.isArray()) {
            return false;
        }
        switch (this.name) {
            case "int": 
            case "byte": 
            case "short": 
            case "char": 
            case "boolean": 
            case "long": 
            case "float": 
            case "double": {
                return true;
            }
        }
        return false;
    }

    boolean isTypeParameter() {
        return this.isTypeParameter;
    }

    public boolean isGeneric() {
        return this.parameters == null || this.parameters.length > 0;
    }

    public List<TypeReference> parameters() {
        return List.of(this.parameters);
    }

    public String fullName() {
        return this.writeTo(new StringBuilder()).toString();
    }

    public boolean isArray() {
        return this.arrayDepth > 0;
    }

    public TypeReference elementOfArray() {
        Preconditions.checkState((boolean)this.isArray(), (String)"Should only be called on array");
        return new TypeReference(this.packageName, this.name, this.arrayDepth - 1, this.isTypeParameter, this.declaringClass, this.modifiers, this.parameters);
    }

    int arrayDepth() {
        return this.arrayDepth;
    }

    public boolean isVoid() {
        return this == VOID;
    }

    public boolean isInnerClass() {
        return this.declaringClass != null;
    }

    List<TypeReference> declaringClasses() {
        LinkedList<TypeReference> parents = new LinkedList<TypeReference>();
        TypeReference parent = this.declaringClass;
        while (parent != null) {
            parents.addFirst(parent);
            parent = parent.declaringClass;
        }
        return parents;
    }

    public int modifiers() {
        return this.modifiers;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TypeReference reference = (TypeReference)o;
        if (this.arrayDepth != reference.arrayDepth) {
            return false;
        }
        if (this.isTypeParameter != reference.isTypeParameter) {
            return false;
        }
        if (this.modifiers != reference.modifiers) {
            return false;
        }
        if (!Objects.equals(this.packageName, reference.packageName)) {
            return false;
        }
        if (!Objects.equals(this.name, reference.name)) {
            return false;
        }
        if (!Arrays.equals(this.parameters, reference.parameters)) {
            return false;
        }
        return Objects.equals(this.declaringClass, reference.declaringClass);
    }

    public int hashCode() {
        int result = this.packageName != null ? this.packageName.hashCode() : 0;
        result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
        result = 31 * result + Arrays.hashCode(this.parameters);
        result = 31 * result + this.arrayDepth;
        result = 31 * result + (this.isTypeParameter ? 1 : 0);
        result = 31 * result + (this.declaringClass != null ? this.declaringClass.hashCode() : 0);
        result = 31 * result + this.modifiers;
        return result;
    }

    String baseName() {
        return this.writeBaseType(new StringBuilder()).toString();
    }

    public String toString() {
        return this.writeTo(new StringBuilder().append("TypeReference[")).append(']').toString();
    }

    StringBuilder writeTo(StringBuilder result) {
        this.writeBaseType(result);
        result.append("[]".repeat(Math.max(0, this.arrayDepth)));
        if (this.parameters != null && this.parameters.length != 0) {
            result.append('<');
            String sep = "";
            for (TypeReference parameter : this.parameters) {
                parameter.writeTo(result.append(sep));
                sep = ",";
            }
            result.append('>');
        }
        return result;
    }

    private StringBuilder writeBaseType(StringBuilder result) {
        if (!this.packageName.isEmpty()) {
            result.append(this.packageName).append('.');
        }
        List<TypeReference> parents = this.declaringClasses();
        for (TypeReference parent : parents) {
            result.append(parent.name).append('.');
        }
        result.append(this.name);
        return result;
    }

    public static abstract class Bound {
        private final TypeReference type;

        private Bound(TypeReference type) {
            this.type = type;
        }

        public abstract TypeReference extendsBound();

        public abstract TypeReference superBound();
    }
}

