/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.codegen.source;

import java.io.IOException;
import java.io.PrintStream;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.processing.Processor;
import javax.tools.Diagnostic;
import javax.tools.JavaFileObject;
import org.neo4j.codegen.CodeGenerationStrategy;
import org.neo4j.codegen.CodeGenerationStrategyNotSupportedException;
import org.neo4j.codegen.CodeGenerator;
import org.neo4j.codegen.CodeGeneratorOption;
import org.neo4j.codegen.CompilationFailureException;
import org.neo4j.codegen.TypeReference;
import org.neo4j.codegen.source.ClasspathHelper;
import org.neo4j.codegen.source.Configuration;
import org.neo4j.codegen.source.JdkCompiler;
import org.neo4j.codegen.source.SourceCodeGenerator;
import org.neo4j.codegen.source.SourceVisitor;
import org.neo4j.codegen.source.WarningsHandler;

public enum SourceCode implements CodeGeneratorOption
{
    SIMPLIFY_TRY_WITH_RESOURCE;

    public static final CodeGenerationStrategy<?> SOURCECODE;
    public static final CodeGeneratorOption PRINT_SOURCE;
    static final CodeGeneratorOption USE_JDK_JAVA_COMPILER;
    public static final CodeGeneratorOption PRINT_WARNINGS;

    private static CodeGeneratorOption printWarningsTo(PrintStream err) {
        return new PrintWarningsOption(err);
    }

    public static CodeGeneratorOption annotationProcessor(Processor processor) {
        return new AnnotationProcessorOption(Objects.requireNonNull(processor));
    }

    public static CodeGeneratorOption sourceLocation(Path path) {
        return new SourceLocationOption(Objects.requireNonNull(path));
    }

    public static CodeGeneratorOption temporarySourceCodeLocation() {
        try {
            return new SourceLocationOption(Files.createTempDirectory(null, new FileAttribute[0]));
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to create temporary directory.", e);
        }
    }

    @Override
    public void applyTo(Object target) {
        if (target instanceof Configuration) {
            ((Configuration)target).withFlag(this);
        }
    }

    static {
        SOURCECODE = new CodeGenerationStrategy<Configuration>(){

            @Override
            protected Configuration createConfigurator(ClassLoader loader) {
                return new Configuration().withOptions("-classpath", ClasspathHelper.fullClasspathStringFor(loader));
            }

            @Override
            protected CodeGenerator createCodeGenerator(ClassLoader loader, Configuration configuration) throws CodeGenerationStrategyNotSupportedException {
                return new SourceCodeGenerator(loader, configuration, configuration.sourceCompilerFor(this));
            }

            @Override
            protected String name() {
                return "SOURCECODE";
            }
        };
        PRINT_SOURCE = new SourceVisitor(){

            @Override
            protected void visitSource(TypeReference reference, CharSequence sourceCode) {
                String[] lines = sourceCode.toString().split("\\n");
                System.out.println("=== Generated class " + reference.fullName() + " ===\n");
                for (int i = 0; i < lines.length; ++i) {
                    System.out.print(i + 1);
                    System.out.print('\t');
                    System.out.println(lines[i]);
                }
            }

            public String toString() {
                return "PRINT_SOURCE";
            }
        };
        USE_JDK_JAVA_COMPILER = JdkCompiler.FACTORY;
        PRINT_WARNINGS = SourceCode.printWarningsTo(System.err);
    }

    private static class PrintWarningsOption
    implements CodeGeneratorOption,
    WarningsHandler {
        private final PrintStream target;

        PrintWarningsOption(PrintStream target) {
            this.target = target;
        }

        @Override
        public void applyTo(Object target) {
            if (target instanceof Configuration) {
                ((Configuration)target).withWarningsHandler(this);
            }
        }

        public String toString() {
            return "PRINT_WARNINGS";
        }

        @Override
        public void handle(List<Diagnostic<? extends JavaFileObject>> diagnostics) {
            for (Diagnostic<? extends JavaFileObject> diagnostic : diagnostics) {
                CompilationFailureException.format(this.target, diagnostic);
            }
        }
    }

    private static class SourceLocationOption
    extends SourceVisitor {
        private final Path path;

        SourceLocationOption(Path path) {
            this.path = path;
        }

        public String toString() {
            return "sourceLocation( " + this.path + " )";
        }

        @Override
        protected void visitSource(TypeReference reference, CharSequence sourceCode) {
            try {
                Path location = this.path(reference);
                Files.createDirectories(location.getParent(), new FileAttribute[0]);
                Files.write(location, Collections.singletonList(sourceCode), Charset.defaultCharset(), new OpenOption[0]);
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to write source code", e);
            }
        }

        private Path path(TypeReference reference) {
            return this.path.resolve(reference.packageName().replace('.', '/') + "/" + reference.name() + ".java");
        }
    }

    private static class AnnotationProcessorOption
    implements CodeGeneratorOption {
        private final Processor processor;

        AnnotationProcessorOption(Processor processor) {
            this.processor = processor;
        }

        @Override
        public void applyTo(Object target) {
            if (target instanceof Configuration) {
                ((Configuration)target).withAnnotationProcessor(this.processor);
            }
        }

        public String toString() {
            return "annotationProcessor( " + this.processor + " )";
        }
    }
}

