/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.codegen;

import java.util.HashMap;
import java.util.Map;
import org.neo4j.codegen.ByteCodeVisitor;
import org.neo4j.codegen.ByteCodes;

class CodeLoader
extends ClassLoader {
    private final Map<String, ByteCodes> bytecodes = new HashMap<String, ByteCodes>();

    CodeLoader(ClassLoader parent) {
        super(parent);
    }

    synchronized void addSources(Iterable<? extends ByteCodes> sources, ByteCodeVisitor visitor) {
        for (ByteCodes byteCodes : sources) {
            visitor.visitByteCode(byteCodes.name(), byteCodes.bytes().duplicate());
            this.bytecodes.put(byteCodes.name(), byteCodes);
        }
    }

    @Override
    protected synchronized Class<?> findClass(String name) throws ClassNotFoundException {
        ByteCodes codes = this.bytecodes.remove(name);
        if (codes == null) {
            throw new ClassNotFoundException(name);
        }
        String packageName = name.substring(0, name.lastIndexOf(46));
        if (this.getPackage(packageName) == null) {
            this.definePackage(packageName, "", "", "", "", "", "", null);
        }
        return this.defineClass(name, codes.bytes(), null);
    }
}

