/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.codegen;

import org.neo4j.codegen.CodeBlock;
import org.neo4j.codegen.ExpressionTemplate;
import org.neo4j.codegen.ExpressionToString;
import org.neo4j.codegen.ExpressionVisitor;
import org.neo4j.codegen.FieldReference;
import org.neo4j.codegen.LocalVariable;
import org.neo4j.codegen.MethodReference;
import org.neo4j.codegen.TypeReference;

public abstract class Expression
extends ExpressionTemplate {
    static final Expression SUPER = new Expression(TypeReference.OBJECT){

        @Override
        public void accept(ExpressionVisitor visitor) {
            visitor.loadThis("super");
        }
    };

    protected Expression(TypeReference type) {
        super(type);
    }

    public abstract void accept(ExpressionVisitor var1);

    public static Expression gt(final Expression lhs, final Expression rhs) {
        return new Expression(TypeReference.BOOLEAN){

            @Override
            public void accept(ExpressionVisitor visitor) {
                visitor.gt(lhs, rhs);
            }
        };
    }

    public static Expression gte(final Expression lhs, final Expression rhs) {
        return new Expression(TypeReference.BOOLEAN){

            @Override
            public void accept(ExpressionVisitor visitor) {
                visitor.gte(lhs, rhs);
            }
        };
    }

    public static Expression lt(final Expression lhs, final Expression rhs) {
        return new Expression(TypeReference.BOOLEAN){

            @Override
            public void accept(ExpressionVisitor visitor) {
                visitor.lt(lhs, rhs);
            }
        };
    }

    public static Expression lte(final Expression lhs, final Expression rhs) {
        return new Expression(TypeReference.BOOLEAN){

            @Override
            public void accept(ExpressionVisitor visitor) {
                visitor.lte(lhs, rhs);
            }
        };
    }

    public static Expression and(final Expression lhs, final Expression rhs) {
        return new Expression(TypeReference.BOOLEAN){

            @Override
            public void accept(ExpressionVisitor visitor) {
                visitor.and(lhs, rhs);
            }
        };
    }

    public static Expression or(final Expression lhs, final Expression rhs) {
        return new Expression(TypeReference.BOOLEAN){

            @Override
            public void accept(ExpressionVisitor visitor) {
                visitor.or(lhs, rhs);
            }
        };
    }

    public static Expression equal(final Expression lhs, final Expression rhs) {
        return new Expression(TypeReference.BOOLEAN){

            @Override
            public void accept(ExpressionVisitor visitor) {
                visitor.equal(lhs, rhs);
            }
        };
    }

    public static Expression load(final LocalVariable variable) {
        return new Expression(variable.type()){

            @Override
            public void accept(ExpressionVisitor visitor) {
                visitor.load(variable);
            }
        };
    }

    public static Expression add(final Expression lhs, final Expression rhs) {
        if (!lhs.type.equals(rhs.type)) {
            throw new IllegalArgumentException(String.format("Cannot add variables with different types. LHS %s, RHS %s", lhs.type.simpleName(), rhs.type.simpleName()));
        }
        return new Expression(lhs.type){

            @Override
            public void accept(ExpressionVisitor visitor) {
                visitor.add(lhs, rhs);
            }
        };
    }

    public static Expression subtract(final Expression lhs, final Expression rhs) {
        if (!lhs.type.equals(rhs.type)) {
            throw new IllegalArgumentException(String.format("Cannot subtract variables with different types. LHS %s, RHS %s", lhs.type.simpleName(), rhs.type.simpleName()));
        }
        return new Expression(lhs.type){

            @Override
            public void accept(ExpressionVisitor visitor) {
                visitor.subtract(lhs, rhs);
            }
        };
    }

    public static Expression multiply(final Expression lhs, final Expression rhs) {
        if (!lhs.type.equals(rhs.type)) {
            throw new IllegalArgumentException(String.format("Cannot multiply variables with different types. LHS %s, RHS %s", lhs.type.simpleName(), rhs.type.simpleName()));
        }
        return new Expression(lhs.type){

            @Override
            public void accept(ExpressionVisitor visitor) {
                visitor.multiply(lhs, rhs);
            }
        };
    }

    public static Expression constant(final Object value) {
        TypeReference reference;
        if (value == null) {
            reference = TypeReference.OBJECT;
        } else if (value instanceof String) {
            reference = TypeReference.typeReference(String.class);
        } else if (value instanceof Long) {
            reference = TypeReference.LONG;
        } else if (value instanceof Integer) {
            reference = TypeReference.INT;
        } else if (value instanceof Double) {
            reference = TypeReference.DOUBLE;
        } else if (value instanceof Boolean) {
            reference = TypeReference.BOOLEAN;
        } else {
            throw new IllegalArgumentException("Not a valid constant!");
        }
        return new Expression(reference){

            @Override
            public void accept(ExpressionVisitor visitor) {
                visitor.constant(value);
            }
        };
    }

    public static Expression newArray(final TypeReference baseType, final Expression ... constants) {
        return new Expression(TypeReference.arrayOf(baseType)){

            @Override
            public void accept(ExpressionVisitor visitor) {
                visitor.newArray(baseType, constants);
            }
        };
    }

    public static Expression get(final Expression target, final FieldReference field) {
        return new Expression(field.type()){

            @Override
            public void accept(ExpressionVisitor visitor) {
                visitor.getField(target, field);
            }
        };
    }

    public static Expression box(final Expression expression) {
        TypeReference type;
        switch (expression.type.simpleName()) {
            case "byte": {
                type = TypeReference.typeReference(Byte.class);
                break;
            }
            case "short": {
                type = TypeReference.typeReference(Short.class);
                break;
            }
            case "int": {
                type = TypeReference.typeReference(Integer.class);
                break;
            }
            case "long": {
                type = TypeReference.typeReference(Long.class);
                break;
            }
            case "char": {
                type = TypeReference.typeReference(Character.class);
                break;
            }
            case "boolean": {
                type = TypeReference.typeReference(Boolean.class);
                break;
            }
            case "float": {
                type = TypeReference.typeReference(Float.class);
                break;
            }
            case "double": {
                type = TypeReference.typeReference(Double.class);
                break;
            }
            default: {
                type = expression.type();
            }
        }
        return new Expression(type){

            @Override
            public void accept(ExpressionVisitor visitor) {
                visitor.box(expression);
            }
        };
    }

    public static Expression unbox(final Expression expression) {
        TypeReference type;
        switch (expression.type.name()) {
            case "java.lang.Byte": {
                type = TypeReference.typeReference(Byte.TYPE);
                break;
            }
            case "java.lang.Short": {
                type = TypeReference.typeReference(Short.TYPE);
                break;
            }
            case "java.lang.Integer": {
                type = TypeReference.typeReference(Integer.TYPE);
                break;
            }
            case "java.lang.Long": {
                type = TypeReference.typeReference(Long.TYPE);
                break;
            }
            case "java.lang.Character": {
                type = TypeReference.typeReference(Character.TYPE);
                break;
            }
            case "java.lang.Boolean": {
                type = TypeReference.typeReference(Boolean.TYPE);
                break;
            }
            case "java.lang.Float": {
                type = TypeReference.typeReference(Float.TYPE);
                break;
            }
            case "java.lang.Double": {
                type = TypeReference.typeReference(Double.TYPE);
                break;
            }
            default: {
                throw new IllegalStateException("Cannot unbox " + expression.type.name());
            }
        }
        return new Expression(type){

            @Override
            public void accept(ExpressionVisitor visitor) {
                visitor.unbox(expression);
            }
        };
    }

    public static Expression get(final FieldReference field) {
        return new Expression(field.type()){

            @Override
            public void accept(ExpressionVisitor visitor) {
                visitor.getStatic(field);
            }
        };
    }

    public static Expression ternaryOnNull(final Expression test, final Expression onTrue, final Expression onFalse) {
        TypeReference reference = onTrue.type.equals(onFalse.type) ? onTrue.type : TypeReference.OBJECT;
        return new Expression(reference){

            @Override
            public void accept(ExpressionVisitor visitor) {
                visitor.ternaryOnNull(test, onTrue, onFalse);
            }
        };
    }

    public static Expression ternaryOnNonNull(final Expression test, final Expression onTrue, final Expression onFalse) {
        TypeReference reference = onTrue.type.equals(onFalse.type) ? onTrue.type : TypeReference.OBJECT;
        return new Expression(reference){

            @Override
            public void accept(ExpressionVisitor visitor) {
                visitor.ternaryOnNonNull(test, onTrue, onFalse);
            }
        };
    }

    public static Expression ternary(final Expression test, final Expression onTrue, final Expression onFalse) {
        TypeReference reference = onTrue.type.equals(onFalse.type) ? onTrue.type : TypeReference.OBJECT;
        return new Expression(reference){

            @Override
            public void accept(ExpressionVisitor visitor) {
                visitor.ternary(test, onTrue, onFalse);
            }
        };
    }

    public static Expression invoke(final Expression target, final MethodReference method, final Expression ... arguments) {
        return new Expression(method.returns()){

            @Override
            public void accept(ExpressionVisitor visitor) {
                visitor.invoke(target, method, arguments);
            }
        };
    }

    public static Expression invoke(final MethodReference method, final Expression ... parameters) {
        return new Expression(method.returns()){

            @Override
            public void accept(ExpressionVisitor visitor) {
                visitor.invoke(method, parameters);
            }
        };
    }

    public static Expression cast(Class<?> type, Expression expression) {
        return Expression.cast(TypeReference.typeReference(type), expression);
    }

    public static Expression cast(TypeReference type, final Expression expression) {
        return new Expression(type){

            @Override
            public void accept(ExpressionVisitor visitor) {
                visitor.cast(this.type, expression);
            }
        };
    }

    public static Expression newInstance(Class<?> type) {
        return Expression.newInstance(TypeReference.typeReference(type));
    }

    public static Expression newInstance(TypeReference type) {
        return new Expression(type){

            @Override
            public void accept(ExpressionVisitor visitor) {
                visitor.newInstance(this.type);
            }
        };
    }

    public static Expression not(final Expression expression) {
        return new Expression(TypeReference.BOOLEAN){

            @Override
            public void accept(ExpressionVisitor visitor) {
                visitor.not(expression);
            }
        };
    }

    public static Expression toDouble(final Expression expression) {
        return new Expression(TypeReference.DOUBLE){

            @Override
            public void accept(ExpressionVisitor visitor) {
                visitor.longToDouble(expression);
            }
        };
    }

    public static Expression pop(final Expression expression) {
        return new Expression(expression.type){

            @Override
            public void accept(ExpressionVisitor visitor) {
                visitor.pop(expression);
            }
        };
    }

    @Override
    Expression materialize(CodeBlock method) {
        return this;
    }

    @Override
    void templateAccept(CodeBlock method, ExpressionVisitor visitor) {
        throw new UnsupportedOperationException("simple expressions should not be invoked as templates");
    }

    public String toString() {
        StringBuilder result = new StringBuilder().append("Expression[");
        this.accept(new ExpressionToString(result));
        return result.append(']').toString();
    }
}

