/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.backup;

import java.io.File;
import java.util.Arrays;
import org.neo4j.backup.ConsistencyCheckFailedException;
import org.neo4j.consistency.ConsistencyCheckService;
import org.neo4j.consistency.checking.full.ConsistencyCheckIncompleteException;
import org.neo4j.helpers.progress.ProgressMonitorFactory;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.logging.LogProvider;

enum ConsistencyCheck {
    NONE{

        @Override
        public boolean runFull(File storeDir, Config tuningConfiguration, ProgressMonitorFactory progressFactory, LogProvider logProvider, FileSystemAbstraction fileSystem, PageCache pageCache, boolean verbose) {
            return true;
        }
    }
    ,
    FULL{

        @Override
        public boolean runFull(File storeDir, Config tuningConfiguration, ProgressMonitorFactory progressFactory, LogProvider logProvider, FileSystemAbstraction fileSystem, PageCache pageCache, boolean verbose) throws ConsistencyCheckFailedException {
            try {
                return new ConsistencyCheckService().runFullConsistencyCheck(storeDir, tuningConfiguration, progressFactory, logProvider, fileSystem, pageCache, verbose).isSuccessful();
            }
            catch (ConsistencyCheckIncompleteException e) {
                throw new ConsistencyCheckFailedException(e);
            }
        }
    };


    public abstract boolean runFull(File var1, Config var2, ProgressMonitorFactory var3, LogProvider var4, FileSystemAbstraction var5, PageCache var6, boolean var7) throws ConsistencyCheckFailedException;

    public static ConsistencyCheck fromString(String name) {
        for (ConsistencyCheck consistencyCheck : ConsistencyCheck.values()) {
            if (!consistencyCheck.toString().equalsIgnoreCase(name)) continue;
            return consistencyCheck;
        }
        throw new IllegalArgumentException("Unknown consistency check name: " + name + ". Supported values: " + Arrays.toString((Object[])ConsistencyCheck.values()));
    }
}

