/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.backup;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.OutputStream;
import java.net.ConnectException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.neo4j.backup.BackupClient;
import org.neo4j.backup.ConsistencyCheck;
import org.neo4j.backup.ConsistencyCheckFailedException;
import org.neo4j.backup.IncrementalBackupNotPossibleException;
import org.neo4j.backup.OnlineBackupSettings;
import org.neo4j.com.RequestContext;
import org.neo4j.com.Response;
import org.neo4j.com.monitor.RequestMonitor;
import org.neo4j.com.storecopy.ExternallyManagedPageCache;
import org.neo4j.com.storecopy.ResponseUnpacker;
import org.neo4j.com.storecopy.StoreCopyClient;
import org.neo4j.com.storecopy.StoreWriter;
import org.neo4j.com.storecopy.TransactionCommittingResponseUnpacker;
import org.neo4j.graphdb.DependencyResolver;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.CancellationRequest;
import org.neo4j.helpers.Exceptions;
import org.neo4j.helpers.Service;
import org.neo4j.helpers.progress.ProgressListener;
import org.neo4j.helpers.progress.ProgressMonitorFactory;
import org.neo4j.io.fs.DefaultFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.FileUtils;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.extension.KernelExtensionFactory;
import org.neo4j.kernel.impl.logging.LogService;
import org.neo4j.kernel.impl.pagecache.StandalonePageCacheFactory;
import org.neo4j.kernel.impl.store.MismatchingStoreIdException;
import org.neo4j.kernel.impl.store.StoreId;
import org.neo4j.kernel.impl.store.id.IdGeneratorImpl;
import org.neo4j.kernel.impl.transaction.log.MissingLogDataException;
import org.neo4j.kernel.impl.transaction.log.ReadableClosablePositionAwareChannel;
import org.neo4j.kernel.impl.transaction.log.TransactionIdStore;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryReader;
import org.neo4j.kernel.impl.transaction.log.entry.VersionAwareLogEntryReader;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.kernel.monitoring.ByteCounterMonitor;
import org.neo4j.kernel.monitoring.Monitors;
import org.neo4j.logging.FormattedLogProvider;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;

class BackupService {
    static final String TOO_OLD_BACKUP = "It's been too long since this backup was last updated, and it has fallen too far behind the database transaction stream for incremental backup to be possible. You need to perform a full backup at this point. You can modify this time interval by setting the '" + GraphDatabaseSettings.keep_logical_logs.name() + "' configuration on the database to a higher value.";
    static final String DIFFERENT_STORE = "Target directory contains full backup of a logically different store.";
    private final FileSystemAbstraction fileSystem;
    private final LogProvider logProvider;
    private final Log log;
    private final Monitors monitors;
    private final VersionAwareLogEntryReader entryReader;

    BackupService() {
        this((FileSystemAbstraction)new DefaultFileSystemAbstraction(), (LogProvider)FormattedLogProvider.toOutputStream((OutputStream)System.out), new Monitors());
    }

    BackupService(FileSystemAbstraction fileSystem, LogProvider logProvider, Monitors monitors) {
        this.fileSystem = fileSystem;
        this.logProvider = logProvider;
        this.log = logProvider.getLog(this.getClass());
        this.monitors = monitors;
        this.entryReader = new VersionAwareLogEntryReader();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    BackupOutcome doFullBackup(final String sourceHostNameOrIp, final int sourcePort, File targetDirectory, ConsistencyCheck consistencyCheck, Config tuningConfiguration, final long timeout, final boolean forensics) {
        if (!this.directoryIsEmpty(targetDirectory)) {
            throw new RuntimeException("Can only perform a full backup into an empty directory but " + targetDirectory + " is not empty");
        }
        long timestamp = System.currentTimeMillis();
        long lastCommittedTx = -1L;
        try (PageCache pageCache = StandalonePageCacheFactory.createPageCache((FileSystemAbstraction)this.fileSystem);){
            StoreCopyClient storeCopier = new StoreCopyClient(targetDirectory, tuningConfiguration, this.loadKernelExtensions(), this.logProvider, (FileSystemAbstraction)new DefaultFileSystemAbstraction(), pageCache, (StoreCopyClient.Monitor)this.monitors.newMonitor(StoreCopyClient.Monitor.class, this.getClass(), new String[0]), forensics);
            storeCopier.copyStore(new StoreCopyClient.StoreCopyRequester(){
                private BackupClient client;

                public Response<?> copyStore(StoreWriter writer) {
                    this.client = new BackupClient(sourceHostNameOrIp, sourcePort, null, (LogProvider)NullLogProvider.getInstance(), StoreId.DEFAULT, timeout, ResponseUnpacker.NO_OP_RESPONSE_UNPACKER, (ByteCounterMonitor)BackupService.this.monitors.newMonitor(ByteCounterMonitor.class, new String[0]), (RequestMonitor)BackupService.this.monitors.newMonitor(RequestMonitor.class, new String[0]), (LogEntryReader<ReadableClosablePositionAwareChannel>)BackupService.this.entryReader);
                    this.client.start();
                    return this.client.fullBackup(writer, forensics);
                }

                public void done() {
                    this.client.stop();
                }
            }, CancellationRequest.NEVER_CANCELLED);
            BackupService.bumpDebugDotLogFileVersion(targetDirectory, timestamp);
            boolean consistent = false;
            try {
                consistent = consistencyCheck.runFull(targetDirectory, tuningConfiguration, ProgressMonitorFactory.textual((OutputStream)System.err), this.logProvider, this.fileSystem, pageCache, false);
            }
            catch (ConsistencyCheckFailedException e) {
                this.log.error("Consistency check incomplete", (Throwable)e);
            }
            this.clearIdFiles(targetDirectory);
            BackupOutcome backupOutcome = new BackupOutcome(lastCommittedTx, consistent);
            return backupOutcome;
        }
        catch (Exception e) {
            throw Exceptions.launderedException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    BackupOutcome doIncrementalBackup(String sourceHostNameOrIp, int sourcePort, File targetDirectory, long timeout, Config config) throws IncrementalBackupNotPossibleException {
        if (!this.directoryContainsDb(targetDirectory)) {
            throw new RuntimeException(targetDirectory + " doesn't contain a database");
        }
        Map<String, String> temporaryDbConfig = this.getTemporaryDbConfig();
        config = config.with(temporaryDbConfig, new Class[0]);
        try (PageCache pageCache = StandalonePageCacheFactory.createPageCache((FileSystemAbstraction)new DefaultFileSystemAbstraction(), (Config)config);){
            GraphDatabaseAPI targetDb = BackupService.startTemporaryDb(targetDirectory, pageCache, config.getParams());
            long backupStartTime = System.currentTimeMillis();
            BackupOutcome outcome = null;
            try {
                outcome = this.doIncrementalBackup(sourceHostNameOrIp, sourcePort, targetDb, timeout);
            }
            finally {
                targetDb.shutdown();
            }
            BackupService.bumpDebugDotLogFileVersion(targetDirectory, backupStartTime);
            this.clearIdFiles(targetDirectory);
            BackupOutcome backupOutcome = outcome;
            return backupOutcome;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private Map<String, String> getTemporaryDbConfig() {
        HashMap<String, String> tempDbConfig = new HashMap<String, String>();
        tempDbConfig.put(OnlineBackupSettings.online_backup_enabled.name(), "false");
        tempDbConfig.put(GraphDatabaseSettings.keep_logical_logs.name(), "true");
        return tempDbConfig;
    }

    BackupOutcome doIncrementalBackupOrFallbackToFull(String sourceHostNameOrIp, int sourcePort, File targetDirectory, ConsistencyCheck consistencyCheck, Config config, long timeout, boolean forensics) {
        if (this.directoryIsEmpty(targetDirectory)) {
            this.log.info("Previous backup not found, a new full backup will be performed.");
            return this.doFullBackup(sourceHostNameOrIp, sourcePort, targetDirectory, consistencyCheck, config, timeout, forensics);
        }
        try {
            this.log.info("Previous backup found, trying incremental backup.");
            return this.doIncrementalBackup(sourceHostNameOrIp, sourcePort, targetDirectory, timeout, config);
        }
        catch (IncrementalBackupNotPossibleException e) {
            try {
                this.log.warn("Attempt to do incremental backup failed.", (Throwable)e);
                this.log.info("Existing backup is too far out of date, a new full backup will be performed.");
                FileUtils.deleteRecursively((File)targetDirectory);
                return this.doFullBackup(sourceHostNameOrIp, sourcePort, targetDirectory, consistencyCheck, config, timeout, forensics);
            }
            catch (Exception fullBackupFailure) {
                throw new RuntimeException("Failed to perform incremental backup, fell back to full backup, but that failed as well: '" + fullBackupFailure.getMessage() + "'.", fullBackupFailure);
            }
        }
    }

    BackupOutcome doIncrementalBackup(String sourceHostNameOrIp, int sourcePort, GraphDatabaseAPI targetDb, long timeout) throws IncrementalBackupNotPossibleException {
        return this.incrementalWithContext(sourceHostNameOrIp, sourcePort, targetDb, timeout, this.slaveContextOf(targetDb));
    }

    private RequestContext slaveContextOf(GraphDatabaseAPI graphDb) {
        TransactionIdStore transactionIdStore = (TransactionIdStore)graphDb.getDependencyResolver().resolveDependency(TransactionIdStore.class);
        return RequestContext.anonymous((long)transactionIdStore.getLastCommittedTransactionId());
    }

    boolean directoryContainsDb(File targetDirectory) {
        return this.fileSystem.fileExists(new File(targetDirectory, "neostore"));
    }

    boolean directoryIsEmpty(File targetDirectory) {
        return !this.fileSystem.isDirectory(targetDirectory) || 0 == this.fileSystem.listFiles(targetDirectory).length;
    }

    static GraphDatabaseAPI startTemporaryDb(File targetDirectory, PageCache pageCache, Map<String, String> config) {
        ExternallyManagedPageCache.GraphDatabaseFactoryWithPageCacheFactory factory = ExternallyManagedPageCache.graphDatabaseFactoryWithPageCache((PageCache)pageCache);
        return (GraphDatabaseAPI)factory.newEmbeddedDatabaseBuilder(targetDirectory).setConfig(config).newGraphDatabase();
    }

    private BackupOutcome incrementalWithContext(String sourceHostNameOrIp, int sourcePort, GraphDatabaseAPI targetDb, long timeout, RequestContext context) throws IncrementalBackupNotPossibleException {
        DependencyResolver resolver = targetDb.getDependencyResolver();
        ProgressTxHandler handler = new ProgressTxHandler();
        TransactionCommittingResponseUnpacker unpacker = new TransactionCommittingResponseUnpacker(resolver, 100, 0L);
        Monitors monitors = (Monitors)resolver.resolveDependency(Monitors.class);
        LogProvider logProvider = ((LogService)resolver.resolveDependency(LogService.class)).getInternalLogProvider();
        BackupClient client = new BackupClient(sourceHostNameOrIp, sourcePort, null, logProvider, targetDb.storeId(), timeout, (ResponseUnpacker)unpacker, (ByteCounterMonitor)monitors.newMonitor(ByteCounterMonitor.class, BackupClient.class, new String[0]), (RequestMonitor)monitors.newMonitor(RequestMonitor.class, BackupClient.class, new String[0]), (LogEntryReader<ReadableClosablePositionAwareChannel>)this.entryReader);
        boolean consistent = false;
        try {
            client.start();
            unpacker.start();
            try (Response<Void> response = client.incrementalBackup(context);){
                unpacker.unpackResponse(response, (ResponseUnpacker.TxHandler)handler);
            }
            consistent = true;
        }
        catch (MismatchingStoreIdException e) {
            throw new RuntimeException(DIFFERENT_STORE, e);
        }
        catch (IOException | RuntimeException e) {
            if (e.getCause() != null && e.getCause() instanceof MissingLogDataException) {
                throw new IncrementalBackupNotPossibleException(TOO_OLD_BACKUP, e.getCause());
            }
            if (e.getCause() != null && e.getCause() instanceof ConnectException) {
                throw new RuntimeException(e.getMessage(), e.getCause());
            }
            throw new RuntimeException("Failed to perform incremental backup.", e);
        }
        catch (Throwable throwable) {
            throw new RuntimeException("Unexpected error", throwable);
        }
        finally {
            try {
                client.stop();
                unpacker.stop();
            }
            catch (Throwable throwable) {
                this.log.warn("Unable to stop backup client", throwable);
            }
        }
        return new BackupOutcome(handler.getLastSeenTransactionId(), consistent);
    }

    private static boolean bumpDebugDotLogFileVersion(File dbDirectory, long toTimestamp) {
        File[] candidates = dbDirectory.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.equals("debug.log");
            }
        });
        if (candidates.length != 1) {
            return false;
        }
        File previous = candidates[0];
        File to = new File(previous.getParentFile(), "debug.log." + toTimestamp);
        return previous.renameTo(to);
    }

    private List<KernelExtensionFactory<?>> loadKernelExtensions() {
        ArrayList kernelExtensions = new ArrayList();
        for (KernelExtensionFactory factory : Service.load(KernelExtensionFactory.class)) {
            kernelExtensions.add(factory);
        }
        return kernelExtensions;
    }

    private void clearIdFiles(File targetDirectory) throws IOException {
        for (File file : this.fileSystem.listFiles(targetDirectory)) {
            if (this.fileSystem.isDirectory(file) || !file.getName().endsWith(".id")) continue;
            long highId = IdGeneratorImpl.readHighId((FileSystemAbstraction)this.fileSystem, (File)file);
            this.fileSystem.deleteFile(file);
            IdGeneratorImpl.createGenerator((FileSystemAbstraction)this.fileSystem, (File)file, (long)highId, (boolean)true);
        }
    }

    private static class ProgressTxHandler
    implements ResponseUnpacker.TxHandler {
        private final ProgressListener progress = ProgressMonitorFactory.textual((OutputStream)System.out).openEnded("Transactions applied", 1000);
        private long lastSeenTransactionId;

        private ProgressTxHandler() {
        }

        public void accept(long transactionId) {
            this.progress.add(1L);
            this.lastSeenTransactionId = transactionId;
        }

        public void done() {
            this.progress.done();
        }

        public long getLastSeenTransactionId() {
            return this.lastSeenTransactionId;
        }
    }

    class BackupOutcome {
        private final boolean consistent;
        private final long lastCommittedTx;

        BackupOutcome(long lastCommittedTx, boolean consistent) {
            this.lastCommittedTx = lastCommittedTx;
            this.consistent = consistent;
        }

        public long getLastCommittedTx() {
            return this.lastCommittedTx;
        }

        public boolean isConsistent() {
            return this.consistent;
        }
    }
}

