/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.test.extension;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.nio.file.Path;
import java.util.Arrays;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.TestInstances;
import org.junit.platform.commons.support.AnnotationSupport;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.io.layout.Neo4jLayout;
import org.neo4j.io.layout.recordstorage.RecordDatabaseLayout;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.testdirectory.TestDirectorySupportExtension;
import org.neo4j.test.utils.TestDirectory;

public class Neo4jLayoutSupportExtension
implements BeforeAllCallback,
BeforeEachCallback {
    public void beforeAll(ExtensionContext context) {
        if (Neo4jLayoutSupportExtension.getLifecycle(context) == TestInstance.Lifecycle.PER_CLASS) {
            this.prepare(context);
        }
    }

    public void beforeEach(ExtensionContext context) {
        if (Neo4jLayoutSupportExtension.getLifecycle(context) == TestInstance.Lifecycle.PER_METHOD) {
            this.prepare(context);
        }
    }

    private void prepare(ExtensionContext context) {
        TestInstances testInstances = context.getRequiredTestInstances();
        TestDirectory testDir = this.getTestDirectory(context);
        Config config = Config.defaults((Setting)GraphDatabaseSettings.neo4j_home, (Object)testDir.homePath());
        Neo4jLayout neo4jLayout = Neo4jLayout.of((Config)config);
        RecordDatabaseLayout databaseLayout = RecordDatabaseLayout.of((Neo4jLayout)neo4jLayout, (String)((String)config.get(GraphDatabaseSettings.default_database)));
        Neo4jLayoutSupportExtension.createDirectories(testDir.getFileSystem(), neo4jLayout, (DatabaseLayout)databaseLayout);
        for (Object testInstance : testInstances.getAllInstances()) {
            Neo4jLayoutSupportExtension.injectInstance(testInstance, neo4jLayout);
            Neo4jLayoutSupportExtension.injectInstance(testInstance, databaseLayout);
        }
    }

    private static void createDirectories(FileSystemAbstraction fs, Neo4jLayout neo4jLayout, DatabaseLayout databaseLayout) {
        Neo4jLayoutSupportExtension.createDirectory(fs, neo4jLayout.homeDirectory());
        Neo4jLayoutSupportExtension.createDirectory(fs, neo4jLayout.databasesDirectory());
        Neo4jLayoutSupportExtension.createDirectory(fs, neo4jLayout.transactionLogsRootDirectory());
        Neo4jLayoutSupportExtension.createDirectory(fs, databaseLayout.databaseDirectory());
        Neo4jLayoutSupportExtension.createDirectory(fs, databaseLayout.getTransactionLogsDirectory());
    }

    private static void createDirectory(FileSystemAbstraction fs, Path directory) {
        try {
            fs.mkdirs(directory);
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed to create directory: " + String.valueOf(directory), e);
        }
    }

    private TestDirectory getTestDirectory(ExtensionContext context) {
        TestDirectory testDir = (TestDirectory)context.getStore(TestDirectorySupportExtension.TEST_DIRECTORY_NAMESPACE).get((Object)"testDirectory", TestDirectory.class);
        if (testDir == null) {
            throw new IllegalStateException(TestDirectorySupportExtension.class.getSimpleName() + " not in scope, make sure to add it before the " + this.getClass().getSimpleName());
        }
        return testDir;
    }

    private static <T> void injectInstance(Object testInstance, T instance) {
        Class<?> testClass = testInstance.getClass();
        do {
            Arrays.stream(testClass.getDeclaredFields()).filter(field -> AnnotationSupport.isAnnotated((AnnotatedElement)field, Inject.class)).filter(field -> field.getType().isAssignableFrom(instance.getClass())).forEach(field -> Neo4jLayoutSupportExtension.setField(testInstance, field, instance));
        } while ((testClass = testClass.getSuperclass()) != null);
    }

    private static void setField(Object testInstance, Field field, Object db) {
        field.setAccessible(true);
        try {
            field.set(testInstance, db);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    private static TestInstance.Lifecycle getLifecycle(ExtensionContext context) {
        return context.getTestInstanceLifecycle().orElse(TestInstance.Lifecycle.PER_METHOD);
    }
}

