/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.kernel.api.helpers;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;
import org.neo4j.internal.kernel.api.DefaultCloseListenable;
import org.neo4j.internal.kernel.api.KernelReadTracer;
import org.neo4j.internal.kernel.api.NodeCursor;
import org.neo4j.internal.kernel.api.NodeValueIndexCursor;
import org.neo4j.internal.kernel.api.helpers.NodeData;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

public class StubNodeValueIndexCursor
extends DefaultCloseListenable
implements NodeValueIndexCursor {
    private int position = -1;
    private final List<NodeData> nodes = new ArrayList<NodeData>();
    private final List<Value[]> values = new ArrayList<Value[]>();

    public StubNodeValueIndexCursor withNode(long id, Value ... vs) {
        this.nodes.add(new NodeData(id, ArrayUtils.EMPTY_INT_ARRAY, Collections.emptyMap()));
        this.values.add(vs);
        return this;
    }

    public void node(NodeCursor cursor) {
    }

    public long nodeReference() {
        return this.position >= 0 && this.position < this.nodes.size() ? this.nodes.get((int)this.position).id : -1L;
    }

    public float score() {
        return Float.NaN;
    }

    public boolean next() {
        return ++this.position < this.nodes.size();
    }

    public void closeInternal() {
    }

    public boolean isClosed() {
        return false;
    }

    public void setTracer(KernelReadTracer tracer) {
    }

    public void removeTracer() {
    }

    public int numberOfProperties() {
        return this.position >= 0 && this.position < this.values.size() ? this.values.get(this.position).length : 0;
    }

    public boolean hasValue() {
        return this.values != null;
    }

    public Value propertyValue(int offset) {
        return this.position >= 0 && this.position < this.values.size() ? this.values.get(this.position)[offset] : Values.NO_VALUE;
    }
}

