/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.kernel.api.helpers;

import java.util.Collections;
import java.util.List;
import org.neo4j.internal.kernel.api.DefaultCloseListenable;
import org.neo4j.internal.kernel.api.KernelReadTracer;
import org.neo4j.internal.kernel.api.NodeCursor;
import org.neo4j.internal.kernel.api.PropertyCursor;
import org.neo4j.internal.kernel.api.RelationshipTraversalCursor;
import org.neo4j.internal.kernel.api.helpers.TestRelationshipChain;
import org.neo4j.storageengine.api.RelationshipSelection;

public class StubRelationshipCursor
extends DefaultCloseListenable
implements RelationshipTraversalCursor {
    private final List<TestRelationshipChain> store;
    private int offset;
    private int chainId;
    private boolean isClosed;
    private long nodeReference;
    private RelationshipSelection selection;

    public StubRelationshipCursor(TestRelationshipChain chain) {
        this(Collections.singletonList(chain));
    }

    public StubRelationshipCursor(List<TestRelationshipChain> store) {
        this.store = store;
        this.chainId = 0;
        this.offset = -1;
        this.isClosed = true;
    }

    void rewind(long nodeReference, RelationshipSelection selection) {
        this.nodeReference = nodeReference;
        this.selection = selection;
        this.offset = -1;
        this.isClosed = true;
    }

    public long relationshipReference() {
        return this.store.get((int)this.chainId).get((int)this.offset).id;
    }

    public int type() {
        return this.store.get((int)this.chainId).get((int)this.offset).type;
    }

    public void source(NodeCursor cursor) {
        throw new UnsupportedOperationException("not implemented");
    }

    public void target(NodeCursor cursor) {
        throw new UnsupportedOperationException("not implemented");
    }

    public void properties(PropertyCursor cursor) {
        throw new UnsupportedOperationException("not implemented");
    }

    public long sourceNodeReference() {
        return this.store.get((int)this.chainId).get((int)this.offset).source;
    }

    public long targetNodeReference() {
        return this.store.get((int)this.chainId).get((int)this.offset).target;
    }

    public long propertiesReference() {
        return -1L;
    }

    public void otherNode(NodeCursor cursor) {
        throw new UnsupportedOperationException("not implemented");
    }

    public long otherNodeReference() {
        return this.targetNodeReference();
    }

    public long originNodeReference() {
        return this.store.get(this.chainId).originNodeId();
    }

    public boolean next() {
        while (this.chainId >= 0 && this.chainId < this.store.size() && this.store.get(this.chainId).isValidOffset(this.offset + 1)) {
            ++this.offset;
            TestRelationshipChain chain = this.store.get(this.chainId);
            if (!chain.isValidOffset(this.offset)) {
                return false;
            }
            TestRelationshipChain.Data data = chain.get(this.offset);
            if (!this.selection.test(data.type, data.relationshipDirection(this.nodeReference))) continue;
            return true;
        }
        return false;
    }

    public void closeInternal() {
        this.isClosed = true;
    }

    public boolean isClosed() {
        return this.isClosed;
    }

    public void setTracer(KernelReadTracer tracer) {
        throw new UnsupportedOperationException("not implemented");
    }

    public void removeTracer() {
        throw new UnsupportedOperationException("not implemented");
    }
}

