/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.kernel.api.helpers;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.neo4j.internal.kernel.api.DefaultCloseListenable;
import org.neo4j.internal.kernel.api.KernelReadTracer;
import org.neo4j.internal.kernel.api.NodeCursor;
import org.neo4j.internal.kernel.api.PropertyCursor;
import org.neo4j.internal.kernel.api.RelationshipTraversalCursor;
import org.neo4j.internal.kernel.api.TokenSet;
import org.neo4j.internal.kernel.api.helpers.NodeData;
import org.neo4j.internal.kernel.api.helpers.StubPropertyCursor;
import org.neo4j.internal.kernel.api.helpers.StubRelationshipCursor;
import org.neo4j.storageengine.api.Degrees;
import org.neo4j.storageengine.api.RelationshipSelection;
import org.neo4j.values.storable.Value;

public class StubNodeCursor
extends DefaultCloseListenable
implements NodeCursor {
    private int offset = -1;
    private boolean dense;
    private List<NodeData> nodes = new ArrayList<NodeData>();
    private int degree;

    public StubNodeCursor() {
        this(true);
    }

    public StubNodeCursor(boolean dense) {
        this.dense = dense;
    }

    void single(long reference) {
        this.offset = Integer.MAX_VALUE;
        for (int i = 0; i < this.nodes.size(); ++i) {
            if (reference != this.nodes.get((int)i).id) continue;
            this.offset = i - 1;
        }
    }

    void scan() {
        this.offset = -1;
    }

    public StubNodeCursor withNode(long id) {
        this.nodes.add(new NodeData(id, new long[0], Collections.emptyMap()));
        return this;
    }

    public StubNodeCursor withNode(long id, long ... labels) {
        this.nodes.add(new NodeData(id, labels, Collections.emptyMap()));
        return this;
    }

    public StubNodeCursor withNode(long id, long[] labels, Map<Integer, Value> properties) {
        this.nodes.add(new NodeData(id, labels, properties));
        return this;
    }

    public StubNodeCursor withDegree(int degree) {
        this.degree = degree;
        return this;
    }

    public long nodeReference() {
        return this.offset >= 0 && this.offset < this.nodes.size() ? this.nodes.get((int)this.offset).id : -1L;
    }

    public TokenSet labels() {
        return this.offset >= 0 && this.offset < this.nodes.size() ? this.nodes.get(this.offset).labelSet() : TokenSet.NONE;
    }

    public TokenSet labelsIgnoringTxStateSetRemove() {
        return this.labels();
    }

    public boolean hasLabel(int label) {
        return this.labels().contains(label);
    }

    public void relationships(RelationshipTraversalCursor relationships, RelationshipSelection selection) {
        ((StubRelationshipCursor)relationships).rewind(this.nodeReference(), selection);
    }

    public void properties(PropertyCursor cursor) {
        ((StubPropertyCursor)cursor).init(this.nodes.get((int)this.offset).properties);
    }

    public long relationshipsReference() {
        throw new UnsupportedOperationException("not implemented");
    }

    public long propertiesReference() {
        if (this.offset >= 0 && this.offset < this.nodes.size()) {
            NodeData node = this.nodes.get(this.offset);
            if (!node.properties.isEmpty()) {
                return node.id;
            }
        }
        return -1L;
    }

    public boolean supportsFastDegreeLookup() {
        return this.dense;
    }

    public int[] relationshipTypes() {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public Degrees degrees(RelationshipSelection selection) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public int degree(RelationshipSelection selection) {
        return this.degree;
    }

    public int degreeWithMax(int maxDegree, RelationshipSelection selection) {
        return Math.min(maxDegree, this.degree);
    }

    public void setTracer(KernelReadTracer tracer) {
        throw new UnsupportedOperationException("not implemented");
    }

    public void removeTracer() {
        throw new UnsupportedOperationException("not implemented");
    }

    public boolean next() {
        if (this.offset == Integer.MAX_VALUE) {
            return false;
        }
        return ++this.offset < this.nodes.size();
    }

    public void closeInternal() {
    }

    public boolean isClosed() {
        return false;
    }
}

