/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.kernel.api.helpers;

import java.util.Map;
import org.neo4j.collection.PrimitiveArrays;
import org.neo4j.internal.kernel.api.TokenSet;
import org.neo4j.values.storable.Value;

class NodeData {
    final long id;
    private final int[] labels;
    final Map<Integer, Value> properties;

    NodeData(long id, int[] labels, Map<Integer, Value> properties) {
        this.id = id;
        this.labels = labels;
        this.properties = properties;
    }

    TokenSet labelSet() {
        return new TokenSet(){

            public int numberOfTokens() {
                return NodeData.this.labels.length;
            }

            public int token(int offset) {
                return NodeData.this.labels[offset];
            }

            public boolean contains(int token) {
                return PrimitiveArrays.contains((int[])NodeData.this.labels, (int)token);
            }

            public int[] all() {
                return NodeData.this.labels;
            }
        };
    }
}

