/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.schema.index;

import java.util.concurrent.ThreadLocalRandom;
import org.neo4j.internal.schema.IndexCapability;
import org.neo4j.internal.schema.IndexConfigCompleter;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.IndexPrototype;
import org.neo4j.internal.schema.IndexQuery;
import org.neo4j.internal.schema.IndexType;
import org.neo4j.internal.schema.SchemaDescriptor;
import org.neo4j.internal.schema.SchemaDescriptors;
import org.neo4j.internal.schema.StorageEngineIndexingBehaviour;
import org.neo4j.util.Preconditions;
import org.neo4j.values.storable.ValueCategory;

public class TestIndexDescriptorFactory {
    private TestIndexDescriptorFactory() {
    }

    public static IndexDescriptor forSchema(SchemaDescriptor schema) {
        return TestIndexDescriptorFactory.forSchema(TestIndexDescriptorFactory.randomId(), schema);
    }

    public static IndexDescriptor forSchema(long id, SchemaDescriptor schema) {
        return TestIndexDescriptorFactory.forSchema(id, IndexType.RANGE, schema);
    }

    public static IndexDescriptor forSchema(IndexType indexType, SchemaDescriptor schema) {
        return TestIndexDescriptorFactory.forSchema(TestIndexDescriptorFactory.randomId(), indexType, schema);
    }

    public static IndexDescriptor forSchema(long id, IndexType indexType, SchemaDescriptor schema) {
        IndexDescriptor index = IndexPrototype.forSchema((SchemaDescriptor)schema).withIndexType(indexType).withName("index_" + id).materialise(id);
        return TestIndexConfigCompleter.INSTANCE.completeConfiguration(index, StorageEngineIndexingBehaviour.EMPTY);
    }

    public static IndexDescriptor uniqueForSchema(SchemaDescriptor schema) {
        return TestIndexDescriptorFactory.uniqueForSchema(IndexType.RANGE, schema);
    }

    public static IndexDescriptor uniqueForSchema(IndexType indexType, SchemaDescriptor schema) {
        int id = TestIndexDescriptorFactory.randomId();
        IndexDescriptor index = IndexPrototype.uniqueForSchema((SchemaDescriptor)schema).withIndexType(indexType).withName("index_" + id).materialise((long)id);
        return TestIndexConfigCompleter.INSTANCE.completeConfiguration(index, StorageEngineIndexingBehaviour.EMPTY);
    }

    public static IndexDescriptor forLabel(int labelId, int ... propertyIds) {
        return TestIndexDescriptorFactory.forSchema((SchemaDescriptor)SchemaDescriptors.forLabel((int)labelId, (int[])propertyIds));
    }

    public static IndexDescriptor forLabel(IndexType indexType, int labelId, int ... propertyIds) {
        return TestIndexDescriptorFactory.forSchema(indexType, (SchemaDescriptor)SchemaDescriptors.forLabel((int)labelId, (int[])propertyIds));
    }

    public static IndexDescriptor forRelType(int relTypeId, int ... propertyIds) {
        return TestIndexDescriptorFactory.forSchema((SchemaDescriptor)SchemaDescriptors.forRelType((int)relTypeId, (int[])propertyIds));
    }

    public static IndexDescriptor uniqueForLabel(int labelId, int ... propertyIds) {
        return TestIndexDescriptorFactory.uniqueForSchema((SchemaDescriptor)SchemaDescriptors.forLabel((int)labelId, (int[])propertyIds));
    }

    public static IndexDescriptor uniqueForLabel(IndexType indexType, int labelId, int ... propertyIds) {
        return TestIndexDescriptorFactory.uniqueForSchema(indexType, (SchemaDescriptor)SchemaDescriptors.forLabel((int)labelId, (int[])propertyIds));
    }

    private static int randomId() {
        return ThreadLocalRandom.current().nextInt(1, 1000);
    }

    private static class TestIndexConfigCompleter
    implements IndexConfigCompleter {
        public static final TestIndexConfigCompleter INSTANCE = new TestIndexConfigCompleter();
        private static final IndexCapability CAPABILITY = new IndexCapability(){

            public boolean supportsOrdering() {
                return false;
            }

            public boolean supportsReturningValues() {
                return false;
            }

            public boolean areValueCategoriesAccepted(ValueCategory ... valueCategories) {
                Preconditions.requireNonEmpty((Object[])valueCategories);
                Preconditions.requireNoNullElements((Object[])valueCategories);
                return true;
            }

            public boolean isQuerySupported(IndexQuery.IndexQueryType queryType, ValueCategory valueCategory) {
                return true;
            }

            public double getCostMultiplier(IndexQuery.IndexQueryType ... queryTypes) {
                return 1.0;
            }

            public boolean supportPartitionedScan(IndexQuery ... queries) {
                Preconditions.requireNonEmpty((Object[])queries);
                Preconditions.requireNoNullElements((Object[])queries);
                return false;
            }
        };

        private TestIndexConfigCompleter() {
        }

        public IndexDescriptor completeConfiguration(IndexDescriptor index, StorageEngineIndexingBehaviour indexingBehaviour) {
            return index.getCapability().equals((Object)IndexCapability.NO_CAPABILITY) ? index.withIndexCapability(CAPABILITY) : index;
        }
    }
}

