/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.test.extension.pagecache;

import java.util.Optional;
import java.util.Random;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.neo4j.io.fs.DefaultFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.test.RandomSupport;
import org.neo4j.test.extension.FileSystemExtension;
import org.neo4j.test.extension.RandomExtension;
import org.neo4j.test.extension.StatefulFieldExtension;
import org.neo4j.test.utils.PageCacheConfig;
import org.neo4j.test.utils.PageCacheSupport;

public class PageCacheSupportExtension
extends StatefulFieldExtension<PageCache> {
    private static final String PAGE_CACHE = "pageCache";
    private static final ExtensionContext.Namespace PAGE_CACHE_NAMESPACE = ExtensionContext.Namespace.create((Object[])new Object[]{"pageCache"});
    private final PageCacheConfig config;

    public PageCacheSupportExtension() {
        this(PageCacheConfig.config());
    }

    public PageCacheSupportExtension(PageCacheConfig config) {
        this.config = config;
    }

    protected String getFieldKey() {
        return PAGE_CACHE;
    }

    protected Class<PageCache> getFieldType() {
        return PageCache.class;
    }

    protected PageCache createField(ExtensionContext extensionContext) {
        ExtensionContext.Store fileSystemStore = PageCacheSupportExtension.getStore((ExtensionContext)extensionContext, (ExtensionContext.Namespace)FileSystemExtension.FILE_SYSTEM_NAMESPACE);
        FileSystemAbstraction contextFileSystem = (FileSystemAbstraction)fileSystemStore.get((Object)"fileSystem", FileSystemAbstraction.class);
        FileSystemAbstraction pageCacheFileSystem = Optional.ofNullable(contextFileSystem).orElseGet(DefaultFileSystemAbstraction::new);
        ExtensionContext.Store randomStore = PageCacheSupportExtension.getStore((ExtensionContext)extensionContext, (ExtensionContext.Namespace)RandomExtension.RANDOM_NAMESPACE);
        RandomSupport randomSupport = (RandomSupport)randomStore.get((Object)"random", RandomSupport.class);
        Random random = randomSupport != null ? randomSupport.random() : new Random();
        return new PageCacheSupport().getPageCache(pageCacheFileSystem, this.config, random);
    }

    public static PageCache getPageCache(FileSystemAbstraction fs, PageCacheConfig config) {
        return new PageCacheSupport().getPageCache(fs, config, new Random());
    }

    public PageCache getPageCache(FileSystemAbstraction fs) {
        return PageCacheSupportExtension.getPageCache(fs, this.config);
    }

    protected ExtensionContext.Namespace getNameSpace() {
        return PAGE_CACHE_NAMESPACE;
    }

    public void afterAll(ExtensionContext context) throws Exception {
        PageCache storedValue = (PageCache)this.getStoredValue(context);
        if (storedValue != null) {
            storedValue.close();
        }
        super.afterAll(context);
    }
}

