/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.io.fs;

import java.io.IOException;
import java.nio.file.Path;
import org.neo4j.io.fs.watcher.FileWatchEventListener;
import org.neo4j.io.fs.watcher.FileWatcher;
import org.neo4j.io.fs.watcher.resource.WatchedResource;

public class SelectiveFileWatcher
implements FileWatcher {
    private final Path specialPath;
    private final FileWatcher defaultFileWatcher;
    private final FileWatcher specificFileWatcher;

    SelectiveFileWatcher(Path specialPath, FileWatcher defaultFileWatcher, FileWatcher specificFileWatcher) {
        this.specialPath = specialPath;
        this.defaultFileWatcher = defaultFileWatcher;
        this.specificFileWatcher = specificFileWatcher;
    }

    public WatchedResource watch(Path path) throws IOException {
        return this.chooseFileWatcher(path).watch(path);
    }

    public void addFileWatchEventListener(FileWatchEventListener listener) {
        this.defaultFileWatcher.addFileWatchEventListener(listener);
        this.specificFileWatcher.addFileWatchEventListener(listener);
    }

    public void removeFileWatchEventListener(FileWatchEventListener listener) {
        this.defaultFileWatcher.removeFileWatchEventListener(listener);
        this.specificFileWatcher.removeFileWatchEventListener(listener);
    }

    public void stopWatching() {
        this.defaultFileWatcher.stopWatching();
        this.specificFileWatcher.stopWatching();
    }

    public void startWatching() throws InterruptedException {
        this.defaultFileWatcher.startWatching();
        this.specificFileWatcher.startWatching();
    }

    public void close() throws IOException {
        this.defaultFileWatcher.close();
        this.specificFileWatcher.close();
    }

    private FileWatcher chooseFileWatcher(Path path) {
        return path.equals(this.specialPath) ? this.specificFileWatcher : this.defaultFileWatcher;
    }
}

