/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.io.pagecache.checking;

import java.io.IOException;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.io.pagecache.impl.DelegatingPageCursor;

public class AccessCheckingReadPageCursor
extends DelegatingPageCursor {
    private boolean hasReadWithoutShouldRetry;

    public AccessCheckingReadPageCursor(PageCursor delegate) {
        super(delegate);
    }

    public byte getByte() {
        this.markAsRead();
        return super.getByte();
    }

    public void getBytes(byte[] data) {
        this.markAsRead();
        super.getBytes(data);
    }

    public short getShort() {
        this.markAsRead();
        return super.getShort();
    }

    public short getShort(int offset) {
        this.markAsRead();
        return super.getShort(offset);
    }

    public long getLong() {
        this.markAsRead();
        return super.getLong();
    }

    public long getLong(int offset) {
        this.markAsRead();
        return super.getLong(offset);
    }

    public void getBytes(byte[] data, int arrayOffset, int length) {
        this.markAsRead();
        super.getBytes(data, arrayOffset, length);
    }

    public int getInt(int offset) {
        this.markAsRead();
        return super.getInt(offset);
    }

    public byte getByte(int offset) {
        this.markAsRead();
        return super.getByte(offset);
    }

    public int getInt() {
        this.markAsRead();
        return super.getInt();
    }

    private void markAsRead() {
        this.hasReadWithoutShouldRetry = true;
    }

    public boolean shouldRetry() throws IOException {
        this.hasReadWithoutShouldRetry = false;
        return super.shouldRetry();
    }

    public boolean next() throws IOException {
        this.assertNoReadWithoutShouldRetry();
        return super.next();
    }

    public void close() {
        this.assertNoReadWithoutShouldRetry();
        super.close();
    }

    public boolean next(long pageId) throws IOException {
        this.assertNoReadWithoutShouldRetry();
        return super.next(pageId);
    }

    private void assertNoReadWithoutShouldRetry() {
        if (this.hasReadWithoutShouldRetry) {
            throw new AssertionError((Object)"Performed read from a read cursor without shouldRetry");
        }
    }
}

