/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.adversaries;

import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.neo4j.adversaries.Adversary;
import org.neo4j.adversaries.StackTraceElementGuardedAdversary;

public class ClassGuardedAdversary
extends StackTraceElementGuardedAdversary {
    public ClassGuardedAdversary(Adversary delegate, Class<?> ... victimClassSet) {
        super(delegate, new ClassFramePredicate(victimClassSet));
    }

    public ClassGuardedAdversary(Adversary delegate, Predicate<StackWalker.StackFrame> predicate) {
        super(delegate, predicate);
    }

    private static class ClassFramePredicate
    implements Predicate<StackWalker.StackFrame> {
        private final Set<String> victimClasses;

        ClassFramePredicate(Class<?> ... victimClassSet) {
            this.victimClasses = Stream.of(victimClassSet).map(Class::getName).collect(Collectors.toSet());
        }

        @Override
        public boolean test(StackWalker.StackFrame stackFrame) {
            return this.victimClasses.contains(stackFrame.getClassName());
        }
    }
}

