/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.test.utils;

import java.util.concurrent.atomic.AtomicBoolean;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;

public final class PageCacheConfig {
    Boolean inconsistentReads;
    Integer pageSize;
    AtomicBoolean nextReadIsInconsistent;
    PageCacheTracer tracer;
    boolean accessChecks;
    String memory;

    public static PageCacheConfig config() {
        return new PageCacheConfig();
    }

    private PageCacheConfig() {
    }

    public PageCacheConfig withInconsistentReads(boolean inconsistentReads) {
        this.inconsistentReads = inconsistentReads;
        return this;
    }

    public PageCacheConfig withInconsistentReads(AtomicBoolean nextReadIsInconsistent) {
        this.nextReadIsInconsistent = nextReadIsInconsistent;
        this.inconsistentReads = Boolean.TRUE;
        return this;
    }

    public PageCacheConfig withPageSize(int pageSize) {
        this.pageSize = pageSize;
        return this;
    }

    public PageCacheConfig withTracer(PageCacheTracer tracer) {
        this.tracer = tracer;
        return this;
    }

    public PageCacheConfig withAccessChecks(boolean accessChecks) {
        this.accessChecks = accessChecks;
        return this;
    }

    public PageCacheConfig withMemory(String memory) {
        this.memory = memory;
        return this;
    }
}

