/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.test.impl;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import org.neo4j.io.ByteUnit;
import org.neo4j.io.fs.StoreChannel;
import org.neo4j.io.memory.ByteBuffers;

public class ChannelInputStream
extends InputStream {
    private final StoreChannel channel;
    private final ByteBuffer buffer = ByteBuffers.allocate((int)8, (ByteUnit)ByteUnit.KibiByte);
    private int position;

    public ChannelInputStream(StoreChannel channel) {
        this.channel = channel;
    }

    @Override
    public int read() throws IOException {
        this.buffer.clear();
        this.buffer.limit(1);
        while (this.buffer.hasRemaining()) {
            int read = this.channel.read(this.buffer);
            if (read != -1) continue;
            return -1;
        }
        this.buffer.flip();
        ++this.position;
        return this.buffer.get() & 0xFF;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        return super.read(b, off, len);
    }

    @Override
    public int available() throws IOException {
        return (int)((long)this.position - this.channel.size());
    }

    @Override
    public void close() throws IOException {
        this.channel.close();
    }
}

