/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.test.extension;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.OutputStream;
import java.io.PrintStream;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.platform.commons.JUnitException;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.resources.Profiler;
import org.neo4j.test.extension.StatefullFieldExtension;
import org.neo4j.test.extension.testdirectory.TestDirectorySupportExtension;
import org.neo4j.test.rule.TestDirectory;

public class ProfilerExtension
extends StatefullFieldExtension<Profiler>
implements BeforeEachCallback,
AfterEachCallback {
    static final String PROFILER_KEY = "profiler";
    static final ExtensionContext.Namespace PROFILER_NAMESPACE = ExtensionContext.Namespace.create((Object[])new Object[]{"profiler"});

    protected String getFieldKey() {
        return PROFILER_KEY;
    }

    protected Class<Profiler> getFieldType() {
        return Profiler.class;
    }

    protected Profiler createField(ExtensionContext extensionContext) {
        return Profiler.profiler();
    }

    protected ExtensionContext.Namespace getNameSpace() {
        return PROFILER_NAMESPACE;
    }

    public void beforeEach(ExtensionContext context) {
        ((Profiler)this.getStoredValue(context)).reset();
    }

    public void afterEach(ExtensionContext context) {
        block8: {
            Profiler profiler = (Profiler)this.getStoredValue(context);
            try {
                profiler.finish();
                if (!context.getExecutionException().isPresent()) break block8;
                String displayName = "Profile: " + context.getTestClass().map(Class::getSimpleName).orElse("class") + "." + context.getDisplayName();
                ByteArrayOutputStream buffer = new ByteArrayOutputStream();
                profiler.printProfile(new PrintStream(buffer), displayName);
                buffer.writeTo(System.err);
                ExtensionContext.Store testDirStore = ProfilerExtension.getStore((ExtensionContext)context, (ExtensionContext.Namespace)TestDirectorySupportExtension.TEST_DIRECTORY_NAMESPACE);
                TestDirectory testDir = (TestDirectory)((Object)testDirStore.get((Object)"testDirectory", TestDirectory.class));
                if (testDir == null || !testDir.isInitialised()) break block8;
                File profileOutputFile = testDir.createFile("profiler-output.txt", new String[0]);
                FileSystemAbstraction fs = testDir.getFileSystem();
                try (OutputStream out = fs.openAsOutputStream(profileOutputFile, false);){
                    buffer.writeTo(out);
                }
            }
            catch (Exception e) {
                throw new JUnitException("Failed to finish profiling and/or produce profiling output.", (Throwable)e);
            }
        }
    }
}

