/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.io.fs;

import java.io.File;
import java.io.IOException;
import org.neo4j.io.fs.watcher.FileWatchEventListener;
import org.neo4j.io.fs.watcher.FileWatcher;
import org.neo4j.io.fs.watcher.resource.WatchedResource;

public class SelectiveFileWatcher
implements FileWatcher {
    private File specialFile;
    private final FileWatcher defaultFileWatcher;
    private final FileWatcher specificFileWatcher;

    SelectiveFileWatcher(File specialFile, FileWatcher defaultFileWatcher, FileWatcher specificFileWatcher) {
        this.specialFile = specialFile;
        this.defaultFileWatcher = defaultFileWatcher;
        this.specificFileWatcher = specificFileWatcher;
    }

    public WatchedResource watch(File file) throws IOException {
        return this.chooseFileWatcher(file).watch(file);
    }

    public void addFileWatchEventListener(FileWatchEventListener listener) {
        this.defaultFileWatcher.addFileWatchEventListener(listener);
        this.specificFileWatcher.addFileWatchEventListener(listener);
    }

    public void removeFileWatchEventListener(FileWatchEventListener listener) {
        this.defaultFileWatcher.removeFileWatchEventListener(listener);
        this.specificFileWatcher.removeFileWatchEventListener(listener);
    }

    public void stopWatching() {
        this.defaultFileWatcher.stopWatching();
        this.specificFileWatcher.stopWatching();
    }

    public void startWatching() throws InterruptedException {
        this.defaultFileWatcher.startWatching();
        this.specificFileWatcher.startWatching();
    }

    public void close() throws IOException {
        this.defaultFileWatcher.close();
        this.specificFileWatcher.close();
    }

    private FileWatcher chooseFileWatcher(File file) {
        return file.equals(this.specialFile) ? this.specificFileWatcher : this.defaultFileWatcher;
    }
}

