/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.io.pagecache.stress;

import java.io.File;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.neo4j.io.fs.DefaultFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.PageSwapperFactory;
import org.neo4j.io.pagecache.impl.SingleFilePageSwapperFactory;
import org.neo4j.io.pagecache.impl.muninn.MuninnPageCache;
import org.neo4j.io.pagecache.stress.Condition;
import org.neo4j.io.pagecache.stress.PageCacheStresser;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorTracerSupplier;
import org.neo4j.io.pagecache.tracing.cursor.context.EmptyVersionContextSupplier;
import org.neo4j.scheduler.JobScheduler;
import org.neo4j.test.scheduler.ThreadPoolJobScheduler;

public class PageCacheStressTest {
    private final int numberOfPages;
    private final int numberOfThreads;
    private final int numberOfCachePages;
    private final PageCacheTracer tracer;
    private final PageCursorTracerSupplier pageCursorTracerSupplier;
    private final Condition condition;
    private final File workingDirectory;

    private PageCacheStressTest(Builder builder) {
        this.numberOfPages = builder.numberOfPages;
        this.numberOfThreads = builder.numberOfThreads;
        this.numberOfCachePages = builder.numberOfCachePages;
        this.tracer = builder.tracer;
        this.pageCursorTracerSupplier = builder.pageCursorTracerSupplier;
        this.condition = builder.condition;
        this.workingDirectory = builder.workingDirectory;
    }

    public void run() throws Exception {
        try (DefaultFileSystemAbstraction fs = new DefaultFileSystemAbstraction();
             ThreadPoolJobScheduler jobScheduler = new ThreadPoolJobScheduler();){
            SingleFilePageSwapperFactory swapperFactory = new SingleFilePageSwapperFactory();
            swapperFactory.open((FileSystemAbstraction)fs);
            try (MuninnPageCache pageCacheUnderTest = new MuninnPageCache((PageSwapperFactory)swapperFactory, this.numberOfCachePages, this.tracer, this.pageCursorTracerSupplier, EmptyVersionContextSupplier.EMPTY, (JobScheduler)jobScheduler);){
                PageCacheStresser pageCacheStresser = new PageCacheStresser(this.numberOfPages, this.numberOfThreads, this.workingDirectory);
                pageCacheStresser.stress((PageCache)pageCacheUnderTest, this.condition);
            }
        }
    }

    public static class Builder {
        int numberOfPages = 10000;
        int numberOfThreads = 7;
        int numberOfCachePages = 1000;
        PageCacheTracer tracer = PageCacheTracer.NULL;
        PageCursorTracerSupplier pageCursorTracerSupplier = PageCursorTracerSupplier.NULL;
        Condition condition;
        File workingDirectory;

        public PageCacheStressTest build() {
            MatcherAssert.assertThat((String)"the cache should cover only a fraction of the mapped file", (Object)this.numberOfPages, (Matcher)CoreMatchers.is((Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(10 * this.numberOfCachePages))));
            return new PageCacheStressTest(this);
        }

        public Builder with(PageCacheTracer tracer) {
            this.tracer = tracer;
            return this;
        }

        public Builder with(Condition condition) {
            this.condition = condition;
            return this;
        }

        public Builder withNumberOfPages(int value) {
            this.numberOfPages = value;
            return this;
        }

        public Builder withNumberOfThreads(int numberOfThreads) {
            this.numberOfThreads = numberOfThreads;
            return this;
        }

        public Builder withNumberOfCachePages(int numberOfCachePages) {
            this.numberOfCachePages = numberOfCachePages;
            return this;
        }

        public Builder withWorkingDirectory(File workingDirectory) {
            this.workingDirectory = workingDirectory;
            return this;
        }

        public Builder withPageCursorTracerSupplier(PageCursorTracerSupplier cursorTracerSupplier) {
            this.pageCursorTracerSupplier = cursorTracerSupplier;
            return this;
        }
    }
}

