/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.io.pagecache;

import java.io.File;
import java.io.IOException;
import org.neo4j.io.pagecache.IOLimiter;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.io.pagecache.PagedFile;
import org.neo4j.io.pagecache.StubPageCursor;

public class StubPagedFile
implements PagedFile {
    private final int pageSize;
    public final int exposedPageSize;
    public long lastPageId = 1L;

    public StubPagedFile(int pageSize) {
        this.pageSize = pageSize;
        this.exposedPageSize = pageSize;
    }

    public PageCursor io(long pageId, int pf_flags) throws IOException {
        StubPageCursor cursor = new StubPageCursor(pageId, this.pageSize);
        this.prepareCursor(cursor);
        return cursor;
    }

    protected void prepareCursor(StubPageCursor cursor) {
    }

    public int pageSize() {
        return this.exposedPageSize;
    }

    public long fileSize() {
        long lastPageId = this.getLastPageId();
        if (lastPageId < 0L) {
            return 0L;
        }
        return (lastPageId + 1L) * (long)this.pageSize();
    }

    public File file() {
        return new File("stub");
    }

    public void flushAndForce() {
    }

    public void flushAndForce(IOLimiter limiter) {
    }

    public long getLastPageId() {
        return this.lastPageId;
    }

    public void close() {
    }

    public void setDeleteOnClose(boolean deleteOnClose) {
    }

    public boolean isDeleteOnClose() {
        return false;
    }
}

