/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.test;

import java.io.Closeable;
import java.io.File;
import org.opentest4j.TestAbortedException;

public final class AssumptionHelper {
    private AssumptionHelper() {
    }

    public static Closeable withoutReadPermissions(File file) {
        if (!file.setReadable(false)) {
            throw new TestAbortedException("User is unable to change permissions on file " + file.getAbsolutePath());
        }
        if (file.canRead()) {
            file.setReadable(true);
            throw new TestAbortedException("User can read unreadable file " + file.getAbsolutePath());
        }
        return () -> file.setReadable(true);
    }

    public static Closeable withoutWritePermissions(File file) {
        if (!file.setWritable(false)) {
            throw new TestAbortedException("User is unable to change permissions on file " + file.getAbsolutePath());
        }
        if (file.canWrite()) {
            file.setWritable(true);
            throw new TestAbortedException("User can read unreadable file " + file.getAbsolutePath());
        }
        return () -> file.setWritable(true);
    }
}

