/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.batchimport;

import java.io.IOException;
import java.util.function.LongFunction;
import org.neo4j.internal.batchimport.InputIterable;
import org.neo4j.internal.batchimport.InputIterator;
import org.neo4j.internal.batchimport.input.InputChunk;
import org.neo4j.internal.batchimport.input.InputEntityVisitor;

public class GeneratingInputIterator<CHUNKSTATE>
implements InputIterator {
    private final LongFunction<CHUNKSTATE> states;
    private final long totalCount;
    private final int batchSize;
    private final Generator<CHUNKSTATE> generator;
    private final long startId;
    private long nextBatch;
    private long numberOfBatches;
    public static final InputIterator EMPTY = new GeneratingInputIterator<Void>(0L, 1, batch -> null, null, 0L){};
    public static final InputIterable EMPTY_ITERABLE = () -> EMPTY;

    public GeneratingInputIterator(long totalCount, int batchSize, LongFunction<CHUNKSTATE> states, Generator<CHUNKSTATE> generator, long startId) {
        this.totalCount = Math.max(totalCount, 0L);
        this.batchSize = Math.max(batchSize, 0);
        this.states = states;
        this.generator = generator;
        this.startId = startId;
        this.numberOfBatches = this.totalCount > 0L && this.batchSize > 0 ? 1L + (this.totalCount - 1L) / (long)this.batchSize : 0L;
    }

    public void close() {
    }

    public InputChunk newChunk() {
        return new Chunk();
    }

    public synchronized boolean next(InputChunk chunk) {
        if (this.numberOfBatches > 1L) {
            long batch = this.nextBatch++;
            ((Chunk)chunk).initialize(this.states.apply(batch), batch, this.batchSize);
            --this.numberOfBatches;
            return true;
        }
        if (this.numberOfBatches == 1L) {
            long remaining = 1L + (this.totalCount - 1L) % (long)this.batchSize;
            long batch = this.nextBatch++;
            ((Chunk)chunk).initialize(this.states.apply(batch), batch, Math.toIntExact(remaining));
            --this.numberOfBatches;
            return true;
        }
        return false;
    }

    public static interface Generator<CHUNKSTATE> {
        public void accept(CHUNKSTATE var1, InputEntityVisitor var2, long var3);
    }

    private class Chunk
    implements InputChunk {
        private CHUNKSTATE state;
        private int count;
        private int itemInBatch;
        private long baseId;

        private Chunk() {
        }

        public void close() {
        }

        private void initialize(CHUNKSTATE state, long batch, int count) {
            this.state = state;
            this.count = count;
            this.baseId = GeneratingInputIterator.this.startId + batch * (long)GeneratingInputIterator.this.batchSize;
            this.itemInBatch = 0;
        }

        public boolean next(InputEntityVisitor visitor) throws IOException {
            if (this.itemInBatch < this.count) {
                GeneratingInputIterator.this.generator.accept(this.state, visitor, this.baseId + (long)this.itemInBatch);
                visitor.endOfEntity();
                ++this.itemInBatch;
                return true;
            }
            return false;
        }
    }
}

