/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.batchimport.input;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.Arrays;
import org.neo4j.csv.reader.Extractors;
import org.neo4j.internal.batchimport.InputIterable;
import org.neo4j.internal.batchimport.InputIterator;
import org.neo4j.internal.batchimport.input.Collector;
import org.neo4j.internal.batchimport.input.Distribution;
import org.neo4j.internal.batchimport.input.Groups;
import org.neo4j.internal.batchimport.input.IdType;
import org.neo4j.internal.batchimport.input.Input;
import org.neo4j.internal.batchimport.input.InputChunk;
import org.neo4j.internal.batchimport.input.InputEntity;
import org.neo4j.internal.batchimport.input.InputEntityVisitor;
import org.neo4j.internal.batchimport.input.Inputs;
import org.neo4j.internal.batchimport.input.PropertySizeCalculator;
import org.neo4j.internal.batchimport.input.RandomEntityDataGenerator;
import org.neo4j.internal.batchimport.input.ReadableGroups;
import org.neo4j.internal.batchimport.input.csv.CsvInput;
import org.neo4j.internal.batchimport.input.csv.Header;
import org.neo4j.internal.batchimport.input.csv.Type;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.memory.EmptyMemoryTracker;
import org.neo4j.memory.MemoryTracker;

public class DataGeneratorInput
implements Input {
    private final long nodes;
    private final long relationships;
    private final IdType idType;
    private final long seed;
    private final Header nodeHeader;
    private final Header relationshipHeader;
    private final Distribution<String> labels;
    private final Distribution<String> relationshipTypes;
    private final float factorBadNodeData;
    private final float factorBadRelationshipData;
    private final long startId;
    private final Groups groups = new Groups();
    private int maxStringLength = 20;

    public DataGeneratorInput(long nodes, long relationships, IdType idType, long seed, long startId, Header nodeHeader, Header relationshipHeader, int labelCount, int relationshipTypeCount, float factorBadNodeData, float factorBadRelationshipData) {
        this.nodes = nodes;
        this.relationships = relationships;
        this.idType = idType;
        this.seed = seed;
        this.startId = startId;
        this.nodeHeader = nodeHeader;
        this.relationshipHeader = relationshipHeader;
        this.factorBadNodeData = factorBadNodeData;
        this.factorBadRelationshipData = factorBadRelationshipData;
        this.labels = new Distribution<String>(DataGeneratorInput.tokens("Label", labelCount));
        this.relationshipTypes = new Distribution<String>(DataGeneratorInput.tokens("TYPE", relationshipTypeCount));
    }

    public InputIterable nodes(Collector badCollector) {
        return () -> new RandomEntityDataGenerator(this.nodes, this.nodes, 10000, this.seed, this.startId, this.nodeHeader, this.labels, this.relationshipTypes, this.factorBadNodeData, this.factorBadRelationshipData, this.maxStringLength);
    }

    public InputIterable relationships(Collector badCollector) {
        return () -> new RandomEntityDataGenerator(this.nodes, this.relationships, 10000, this.seed, this.startId, this.relationshipHeader, this.labels, this.relationshipTypes, this.factorBadNodeData, this.factorBadRelationshipData, this.maxStringLength);
    }

    public IdType idType() {
        return this.idType;
    }

    public ReadableGroups groups() {
        return this.groups;
    }

    public Input.Estimates calculateEstimates(PropertySizeCalculator valueSizeCalculator) {
        int sampleSize = 100;
        InputEntity[] nodeSample = this.sample(this.nodes(Collector.EMPTY), sampleSize);
        double labelsPerNodeEstimate = DataGeneratorInput.sampleLabels(nodeSample);
        double[] nodePropertyEstimate = DataGeneratorInput.sampleProperties(nodeSample, valueSizeCalculator);
        double[] relationshipPropertyEstimate = DataGeneratorInput.sampleProperties(this.sample(this.relationships(Collector.EMPTY), sampleSize), valueSizeCalculator);
        return Input.knownEstimates((long)this.nodes, (long)this.relationships, (long)((long)((double)this.nodes * nodePropertyEstimate[0])), (long)((long)((double)this.relationships * relationshipPropertyEstimate[0])), (long)((long)((double)this.nodes * nodePropertyEstimate[1])), (long)((long)((double)this.relationships * relationshipPropertyEstimate[1])), (long)((long)((double)this.nodes * labelsPerNodeEstimate)));
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private InputEntity[] sample(InputIterable source, int size) {
        try (InputIterator iterator = source.iterator();){
            InputEntity[] inputEntityArray;
            block16: {
                InputChunk chunk = iterator.newChunk();
                try {
                    InputEntity[] sample = new InputEntity[size];
                    int cursor = 0;
                    while (cursor < size && iterator.next(chunk)) {
                        while (cursor < size && chunk.next((InputEntityVisitor)(sample[cursor++] = new InputEntity()))) {
                        }
                    }
                    inputEntityArray = sample;
                    if (chunk == null) break block16;
                }
                catch (Throwable throwable) {
                    if (chunk != null) {
                        try {
                            chunk.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                chunk.close();
            }
            return inputEntityArray;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private static double sampleLabels(InputEntity[] nodes) {
        int labels = 0;
        for (InputEntity node : nodes) {
            if (node == null) continue;
            labels += node.labels().length;
        }
        return (double)labels / (double)nodes.length;
    }

    private static double[] sampleProperties(InputEntity[] sample, PropertySizeCalculator valueSizeCalculator) {
        int propertiesPerEntity = sample[0].propertyCount();
        long propertiesSize = 0L;
        for (InputEntity entity : sample) {
            if (entity == null) continue;
            propertiesSize += (long)Inputs.calculatePropertySize((InputEntity)entity, (PropertySizeCalculator)valueSizeCalculator, (CursorContext)CursorContext.NULL, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        }
        double propertySizePerEntity = (double)propertiesSize / (double)sample.length;
        return new double[]{propertiesPerEntity, propertySizePerEntity};
    }

    public static Header bareboneNodeHeader(IdType idType, Extractors extractors) {
        return DataGeneratorInput.bareboneNodeHeader(null, idType, extractors, new Header.Entry[0]);
    }

    public static Header bareboneNodeHeader(String idKey, IdType idType, Extractors extractors, Header.Entry ... additionalEntries) {
        ArrayList<Header.Entry> entries = new ArrayList<Header.Entry>();
        entries.add(new Header.Entry(idKey, Type.ID, null, CsvInput.idExtractor((IdType)idType, (Extractors)extractors)));
        entries.add(new Header.Entry(null, Type.LABEL, null, extractors.stringArray()));
        entries.addAll(Arrays.asList(additionalEntries));
        return new Header(entries.toArray(new Header.Entry[0]));
    }

    public static Header bareboneRelationshipHeader(IdType idType, Extractors extractors, Header.Entry ... additionalEntries) {
        ArrayList<Header.Entry> entries = new ArrayList<Header.Entry>();
        entries.add(new Header.Entry(null, Type.START_ID, null, CsvInput.idExtractor((IdType)idType, (Extractors)extractors)));
        entries.add(new Header.Entry(null, Type.END_ID, null, CsvInput.idExtractor((IdType)idType, (Extractors)extractors)));
        entries.add(new Header.Entry(null, Type.TYPE, null, extractors.string()));
        entries.addAll(Arrays.asList(additionalEntries));
        return new Header(entries.toArray(new Header.Entry[0]));
    }

    private static String[] tokens(String prefix, int count) {
        String[] result = new String[count];
        for (int i = 0; i < count; ++i) {
            result[i] = prefix + (i + 1);
        }
        return result;
    }
}

