/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.compat._59;

import java.lang.reflect.Field;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.SettingBuilder;
import org.neo4j.configuration.SettingValueParser;
import org.neo4j.dbms.systemgraph.TopologyGraphDbmsModel;
import org.neo4j.gds.compat.DatabaseMode;
import org.neo4j.gds.compat.Setting;
import org.neo4j.gds.compat.SettingProxyApi;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.kernel.impl.factory.GraphDatabaseFacade;
import org.neo4j.kernel.internal.GraphDatabaseAPI;

public class SettingProxyImpl
implements SettingProxyApi {
    public <T> org.neo4j.graphdb.config.Setting<T> setting(Setting<T> setting) {
        SettingBuilder builder = SettingBuilder.newBuilder((String)setting.name(), (SettingValueParser)setting.parser(), (Object)setting.defaultValue());
        if (setting.dynamic()) {
            builder = builder.dynamic();
        }
        if (setting.immutable()) {
            builder = builder.immutable();
        }
        setting.dependency().ifPresent(arg_0 -> ((SettingBuilder)builder).setDependency(arg_0));
        setting.constraints().forEach(arg_0 -> ((SettingBuilder)builder).addConstraint(arg_0));
        return builder.build();
    }

    public DatabaseMode databaseMode(Config config, GraphDatabaseService databaseService) {
        return switch (((GraphDatabaseAPI)databaseService).mode()) {
            default -> throw new IncompatibleClassChangeError();
            case TopologyGraphDbmsModel.HostedOnMode.RAFT -> DatabaseMode.CORE;
            case TopologyGraphDbmsModel.HostedOnMode.REPLICA -> DatabaseMode.READ_REPLICA;
            case TopologyGraphDbmsModel.HostedOnMode.SINGLE -> DatabaseMode.SINGLE;
            case TopologyGraphDbmsModel.HostedOnMode.VIRTUAL -> throw new UnsupportedOperationException("What's a virtual database anyway?");
        };
    }

    public void setDatabaseMode(Config config, DatabaseMode databaseMode, GraphDatabaseService databaseService) {
        if (!(databaseService instanceof GraphDatabaseFacade)) {
            throw new IllegalArgumentException("Cannot set database mode on a database that is not a GraphDatabaseFacade");
        }
        GraphDatabaseFacade db = (GraphDatabaseFacade)databaseService;
        try {
            Field modeField = GraphDatabaseFacade.class.getDeclaredField("mode");
            modeField.setAccessible(true);
            modeField.set(db, switch (databaseMode) {
                default -> throw new IncompatibleClassChangeError();
                case DatabaseMode.CORE -> TopologyGraphDbmsModel.HostedOnMode.RAFT;
                case DatabaseMode.READ_REPLICA -> TopologyGraphDbmsModel.HostedOnMode.REPLICA;
                case DatabaseMode.SINGLE -> TopologyGraphDbmsModel.HostedOnMode.SINGLE;
            });
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException("Could not set the mode field because it no longer exists. This compat layer needs to be updated.", e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Could not get the permissions to set the mode field.", e);
        }
    }

    public String secondaryModeName() {
        return "Secondary";
    }
}

