/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.compat._59;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.neo4j.common.DependencyResolver;
import org.neo4j.common.EntityType;
import org.neo4j.configuration.BootloaderSettings;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.configuration.SettingValueParsers;
import org.neo4j.configuration.connectors.ConnectorPortRegister;
import org.neo4j.configuration.connectors.ConnectorType;
import org.neo4j.configuration.helpers.DatabaseNameValidator;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.exceptions.KernelException;
import org.neo4j.fabric.FabricDatabaseManager;
import org.neo4j.gds.annotation.SuppressForbidden;
import org.neo4j.gds.compat.BoltTransactionRunner;
import org.neo4j.gds.compat.CompatCallableProcedure;
import org.neo4j.gds.compat.CompatExecutionMonitor;
import org.neo4j.gds.compat.CompatIndexQuery;
import org.neo4j.gds.compat.CompatInput;
import org.neo4j.gds.compat.CompatUserAggregationFunction;
import org.neo4j.gds.compat.CompositeNodeCursor;
import org.neo4j.gds.compat.CustomAccessMode;
import org.neo4j.gds.compat.GdsDatabaseLayout;
import org.neo4j.gds.compat.GdsDatabaseManagementServiceBuilder;
import org.neo4j.gds.compat.GdsGraphDatabaseAPI;
import org.neo4j.gds.compat.GraphDatabaseApiProxy;
import org.neo4j.gds.compat.InputEntityIdVisitor;
import org.neo4j.gds.compat.InternalReadOps;
import org.neo4j.gds.compat.Neo4jProxyApi;
import org.neo4j.gds.compat.PropertyReference;
import org.neo4j.gds.compat.StoreScan;
import org.neo4j.gds.compat.TestLog;
import org.neo4j.gds.compat._59.BoltTransactionRunnerImpl;
import org.neo4j.gds.compat._59.CallableProcedureImpl;
import org.neo4j.gds.compat._59.CallableUserAggregationFunctionImpl;
import org.neo4j.gds.compat._59.CompatAccessModeImpl;
import org.neo4j.gds.compat._59.CompatGraphDatabaseAPIImpl;
import org.neo4j.gds.compat._59.CompatIndexQueryImpl;
import org.neo4j.gds.compat._59.CompatUsernameAuthSubjectImpl;
import org.neo4j.gds.compat._59.CompositeNodeCursorImpl;
import org.neo4j.gds.compat._59.GdsDatabaseLayoutImpl;
import org.neo4j.gds.compat._59.GdsDatabaseManagementServiceBuilderImpl;
import org.neo4j.gds.compat._59.NodeLabelIndexLookupImpl;
import org.neo4j.gds.compat._59.PartitionedStoreScan;
import org.neo4j.gds.compat._59.ReferencePropertyReference;
import org.neo4j.gds.compat._59.ScanBasedStoreScanImpl;
import org.neo4j.gds.compat._59.TestLogImpl;
import org.neo4j.gds.compat._59.VirtualRelationshipImpl;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.config.Configuration;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.internal.batchimport.AdditionalInitialIds;
import org.neo4j.internal.batchimport.BatchImporter;
import org.neo4j.internal.batchimport.BatchImporterFactory;
import org.neo4j.internal.batchimport.IndexConfig;
import org.neo4j.internal.batchimport.IndexImporterFactory;
import org.neo4j.internal.batchimport.InputIterable;
import org.neo4j.internal.batchimport.Monitor;
import org.neo4j.internal.batchimport.input.Collector;
import org.neo4j.internal.batchimport.input.Group;
import org.neo4j.internal.batchimport.input.Input;
import org.neo4j.internal.batchimport.input.InputEntityVisitor;
import org.neo4j.internal.batchimport.input.PropertySizeCalculator;
import org.neo4j.internal.batchimport.input.ReadableGroups;
import org.neo4j.internal.batchimport.staging.ExecutionMonitor;
import org.neo4j.internal.batchimport.staging.StageExecution;
import org.neo4j.internal.helpers.HostnamePort;
import org.neo4j.internal.id.IdGenerator;
import org.neo4j.internal.id.IdGeneratorFactory;
import org.neo4j.internal.id.IdType;
import org.neo4j.internal.kernel.api.Cursor;
import org.neo4j.internal.kernel.api.IndexQueryConstraints;
import org.neo4j.internal.kernel.api.IndexReadSession;
import org.neo4j.internal.kernel.api.NodeCursor;
import org.neo4j.internal.kernel.api.NodeLabelIndexCursor;
import org.neo4j.internal.kernel.api.NodeValueIndexCursor;
import org.neo4j.internal.kernel.api.PartitionedScan;
import org.neo4j.internal.kernel.api.PropertyCursor;
import org.neo4j.internal.kernel.api.PropertyIndexQuery;
import org.neo4j.internal.kernel.api.QueryContext;
import org.neo4j.internal.kernel.api.Read;
import org.neo4j.internal.kernel.api.RelationshipScanCursor;
import org.neo4j.internal.kernel.api.Scan;
import org.neo4j.internal.kernel.api.TokenPredicate;
import org.neo4j.internal.kernel.api.TokenReadSession;
import org.neo4j.internal.kernel.api.connectioninfo.ClientConnectionInfo;
import org.neo4j.internal.kernel.api.procs.FieldSignature;
import org.neo4j.internal.kernel.api.procs.Neo4jTypes;
import org.neo4j.internal.kernel.api.procs.ProcedureSignature;
import org.neo4j.internal.kernel.api.procs.QualifiedName;
import org.neo4j.internal.kernel.api.procs.UserFunctionSignature;
import org.neo4j.internal.kernel.api.security.AccessMode;
import org.neo4j.internal.kernel.api.security.AuthSubject;
import org.neo4j.internal.kernel.api.security.SecurityContext;
import org.neo4j.internal.recordstorage.RecordIdType;
import org.neo4j.internal.schema.IndexCapability;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.IndexOrder;
import org.neo4j.internal.schema.SchemaDescriptor;
import org.neo4j.internal.schema.SchemaDescriptors;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.io.layout.Neo4jLayout;
import org.neo4j.io.layout.recordstorage.RecordDatabaseLayout;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.io.pagecache.context.CursorContextFactory;
import org.neo4j.io.pagecache.context.EmptyVersionContextSupplier;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.KernelTransactionHandle;
import org.neo4j.kernel.api.procedure.CallableProcedure;
import org.neo4j.kernel.api.procedure.CallableUserAggregationFunction;
import org.neo4j.kernel.database.NormalizedDatabaseName;
import org.neo4j.kernel.impl.coreapi.InternalTransaction;
import org.neo4j.kernel.impl.index.schema.IndexImporterFactoryImpl;
import org.neo4j.kernel.impl.query.QueryExecutionConfiguration;
import org.neo4j.kernel.impl.query.TransactionalContext;
import org.neo4j.kernel.impl.query.TransactionalContextFactory;
import org.neo4j.kernel.impl.store.RecordStore;
import org.neo4j.kernel.impl.store.format.RecordFormatSelector;
import org.neo4j.kernel.impl.store.format.RecordFormats;
import org.neo4j.kernel.impl.store.record.AbstractBaseRecord;
import org.neo4j.kernel.impl.transaction.log.EmptyLogTailMetadata;
import org.neo4j.kernel.impl.transaction.log.LogTailMetadata;
import org.neo4j.kernel.impl.transaction.log.files.TransactionLogInitializer;
import org.neo4j.logging.InternalLogProvider;
import org.neo4j.logging.Log;
import org.neo4j.logging.internal.LogService;
import org.neo4j.memory.EmptyMemoryTracker;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.procedure.Mode;
import org.neo4j.scheduler.JobScheduler;
import org.neo4j.ssl.config.SslPolicyLoader;
import org.neo4j.storageengine.api.PropertySelection;
import org.neo4j.storageengine.api.Reference;
import org.neo4j.storageengine.api.StorageEngineFactory;
import org.neo4j.util.Bits;
import org.neo4j.values.storable.TextArray;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.ValueCategory;
import org.neo4j.values.storable.Values;
import org.neo4j.values.virtual.MapValue;
import org.neo4j.values.virtual.NodeValue;
import org.neo4j.values.virtual.VirtualValues;

public final class Neo4jProxyImpl
implements Neo4jProxyApi {
    public GdsGraphDatabaseAPI newDb(DatabaseManagementService dbms) {
        return new CompatGraphDatabaseAPIImpl(dbms);
    }

    public String validateExternalDatabaseName(String databaseName) {
        NormalizedDatabaseName normalizedName = new NormalizedDatabaseName(databaseName);
        DatabaseNameValidator.validateExternalDatabaseName((NormalizedDatabaseName)normalizedName);
        return normalizedName.name();
    }

    public AccessMode accessMode(CustomAccessMode customAccessMode) {
        return new CompatAccessModeImpl(customAccessMode);
    }

    public String username(AuthSubject subject) {
        return subject.executingUser();
    }

    public SecurityContext securityContext(String username, AuthSubject authSubject, AccessMode mode, String databaseName) {
        return new SecurityContext((AuthSubject)new CompatUsernameAuthSubjectImpl(username, authSubject), mode, ClientConnectionInfo.EMBEDDED_CONNECTION, databaseName);
    }

    public long getHighId(RecordStore<? extends AbstractBaseRecord> recordStore) {
        return recordStore.getIdGenerator().getHighId();
    }

    public List<StoreScan<NodeLabelIndexCursor>> entityCursorScan(KernelTransaction transaction, int[] labelIds, int batchSize, boolean allowPartitionedScan) {
        if (allowPartitionedScan) {
            return this.partitionedNodeLabelIndexScan(transaction, batchSize, labelIds);
        }
        Read read = transaction.dataRead();
        return Arrays.stream(labelIds).mapToObj(arg_0 -> ((Read)read).nodeLabelScan(arg_0)).map(scan -> this.scanToStoreScan((Scan)scan, batchSize)).collect(Collectors.toList());
    }

    public PropertyCursor allocatePropertyCursor(KernelTransaction kernelTransaction) {
        return kernelTransaction.cursors().allocatePropertyCursor(kernelTransaction.cursorContext(), kernelTransaction.memoryTracker());
    }

    public PropertyReference propertyReference(NodeCursor nodeCursor) {
        return ReferencePropertyReference.of(nodeCursor.propertiesReference());
    }

    public PropertyReference propertyReference(RelationshipScanCursor relationshipScanCursor) {
        return ReferencePropertyReference.of(relationshipScanCursor.propertiesReference());
    }

    public PropertyReference noPropertyReference() {
        return ReferencePropertyReference.empty();
    }

    public void nodeProperties(KernelTransaction kernelTransaction, long nodeReference, PropertyReference reference, PropertyCursor cursor) {
        Reference neoReference = ((ReferencePropertyReference)reference).reference;
        kernelTransaction.dataRead().nodeProperties(nodeReference, neoReference, PropertySelection.ALL_PROPERTIES, cursor);
    }

    public void relationshipProperties(KernelTransaction kernelTransaction, long relationshipReference, PropertyReference reference, PropertyCursor cursor) {
        Reference neoReference = ((ReferencePropertyReference)reference).reference;
        kernelTransaction.dataRead().relationshipProperties(relationshipReference, neoReference, PropertySelection.ALL_PROPERTIES, cursor);
    }

    public NodeCursor allocateNodeCursor(KernelTransaction kernelTransaction) {
        return kernelTransaction.cursors().allocateNodeCursor(kernelTransaction.cursorContext());
    }

    public RelationshipScanCursor allocateRelationshipScanCursor(KernelTransaction kernelTransaction) {
        return kernelTransaction.cursors().allocateRelationshipScanCursor(kernelTransaction.cursorContext());
    }

    public NodeLabelIndexCursor allocateNodeLabelIndexCursor(KernelTransaction kernelTransaction) {
        return kernelTransaction.cursors().allocateNodeLabelIndexCursor(kernelTransaction.cursorContext());
    }

    public NodeValueIndexCursor allocateNodeValueIndexCursor(KernelTransaction kernelTransaction) {
        return kernelTransaction.cursors().allocateNodeValueIndexCursor(kernelTransaction.cursorContext(), kernelTransaction.memoryTracker());
    }

    public boolean hasNodeLabelIndex(KernelTransaction kernelTransaction) {
        return NodeLabelIndexLookupImpl.hasNodeLabelIndex(kernelTransaction);
    }

    public StoreScan<NodeLabelIndexCursor> nodeLabelIndexScan(KernelTransaction transaction, int labelId, int batchSize, boolean allowPartitionedScan) {
        if (allowPartitionedScan) {
            return this.partitionedNodeLabelIndexScan(transaction, batchSize, labelId).get(0);
        }
        Read read = transaction.dataRead();
        return this.scanToStoreScan(read.nodeLabelScan(labelId), batchSize);
    }

    public <C extends Cursor> StoreScan<C> scanToStoreScan(Scan<C> scan, int batchSize) {
        return new ScanBasedStoreScanImpl<C>(scan, batchSize);
    }

    private List<StoreScan<NodeLabelIndexCursor>> partitionedNodeLabelIndexScan(KernelTransaction transaction, int batchSize, int ... labelIds) {
        IndexDescriptor indexDescriptor = NodeLabelIndexLookupImpl.findUsableMatchingIndex(transaction, (SchemaDescriptor)SchemaDescriptors.forAnyEntityTokens((EntityType)EntityType.NODE));
        if (indexDescriptor == IndexDescriptor.NO_INDEX) {
            throw new IllegalStateException("There is no index that can back a node label scan.");
        }
        Read read = transaction.dataRead();
        int maxToken = labelIds[0];
        long maxCount = read.countsForNodeWithoutTxState(labelIds[0]);
        for (int i = 1; i < labelIds.length; ++i) {
            long count = read.countsForNodeWithoutTxState(labelIds[i]);
            if (count <= maxCount) continue;
            maxCount = count;
            maxToken = labelIds[i];
        }
        int numberOfPartitions = PartitionedStoreScan.getNumberOfPartitions(maxCount, batchSize);
        try {
            TokenReadSession session = read.tokenReadSession(indexDescriptor);
            PartitionedScan partitionedScan = read.nodeLabelScan(session, numberOfPartitions, transaction.cursorContext(), new TokenPredicate(maxToken));
            ArrayList<StoreScan<NodeLabelIndexCursor>> scans = new ArrayList<StoreScan<NodeLabelIndexCursor>>(labelIds.length);
            scans.add(new PartitionedStoreScan((PartitionedScan<NodeLabelIndexCursor>)partitionedScan));
            for (int labelToken : labelIds) {
                if (labelToken == maxToken) continue;
                PartitionedScan scan = read.nodeLabelScan(session, partitionedScan, new TokenPredicate(labelToken));
                scans.add(new PartitionedStoreScan((PartitionedScan<NodeLabelIndexCursor>)scan));
            }
            return scans;
        }
        catch (KernelException e) {
            throw new RuntimeException("Unexpected error while initialising reading from node label index", e);
        }
    }

    public CompatIndexQuery rangeIndexQuery(int propertyKeyId, double from, boolean fromInclusive, double to, boolean toInclusive) {
        return new CompatIndexQueryImpl((PropertyIndexQuery)PropertyIndexQuery.range((int)propertyKeyId, (Number)from, (boolean)fromInclusive, (Number)to, (boolean)toInclusive));
    }

    public CompatIndexQuery rangeAllIndexQuery(int propertyKeyId) {
        PropertyIndexQuery.RangePredicate rangePredicate = PropertyIndexQuery.range((int)propertyKeyId, (Value)Values.doubleValue((double)Double.NEGATIVE_INFINITY), (boolean)true, (Value)Values.doubleValue((double)Double.POSITIVE_INFINITY), (boolean)true);
        return new CompatIndexQueryImpl((PropertyIndexQuery)rangePredicate);
    }

    public void nodeIndexSeek(Read dataRead, IndexReadSession index, NodeValueIndexCursor cursor, IndexOrder indexOrder, boolean needsValues, CompatIndexQuery query) throws KernelException {
        IndexQueryConstraints indexQueryConstraints = indexOrder == IndexOrder.NONE ? IndexQueryConstraints.unordered((boolean)needsValues) : IndexQueryConstraints.constrained((IndexOrder)indexOrder, (boolean)needsValues);
        dataRead.nodeIndexSeek((QueryContext)dataRead, index, cursor, indexQueryConstraints, new PropertyIndexQuery[]{((CompatIndexQueryImpl)query).indexQuery});
    }

    public CompositeNodeCursor compositeNodeCursor(List<NodeLabelIndexCursor> cursors, int[] labelIds) {
        return new CompositeNodeCursorImpl(cursors, labelIds);
    }

    public org.neo4j.internal.batchimport.Configuration batchImporterConfig(final int batchSize, final int writeConcurrency, Optional<Long> pageCacheMemory, final boolean highIO, final IndexConfig indexConfig) {
        return new org.neo4j.internal.batchimport.Configuration(){

            public int batchSize() {
                return batchSize;
            }

            public int maxNumberOfWorkerThreads() {
                return writeConcurrency;
            }

            public boolean highIO() {
                return highIO;
            }

            public IndexConfig indexConfig() {
                return indexConfig;
            }
        };
    }

    public int writeConcurrency(org.neo4j.internal.batchimport.Configuration batchImportConfiguration) {
        return batchImportConfiguration.maxNumberOfWorkerThreads();
    }

    public BatchImporter instantiateBatchImporter(BatchImporterFactory factory, GdsDatabaseLayout directoryStructure, FileSystemAbstraction fileSystem, PageCacheTracer pageCacheTracer, org.neo4j.internal.batchimport.Configuration configuration, LogService logService, ExecutionMonitor executionMonitor, AdditionalInitialIds additionalInitialIds, Config dbConfig, RecordFormats recordFormats, JobScheduler jobScheduler, Collector badCollector) {
        dbConfig.set(GraphDatabaseSettings.db_format, (Object)recordFormats.name());
        DatabaseLayout databaseLayout = ((GdsDatabaseLayoutImpl)directoryStructure).databaseLayout();
        return factory.instantiate(databaseLayout, fileSystem, pageCacheTracer, configuration, logService, executionMonitor, additionalInitialIds, (LogTailMetadata)new EmptyLogTailMetadata(dbConfig), dbConfig, Monitor.NO_MONITOR, jobScheduler, badCollector, TransactionLogInitializer.getLogFilesInitializer(), (IndexImporterFactory)new IndexImporterFactoryImpl(), (MemoryTracker)EmptyMemoryTracker.INSTANCE, new CursorContextFactory(PageCacheTracer.NULL, EmptyVersionContextSupplier.EMPTY));
    }

    public Input batchInputFrom(CompatInput compatInput) {
        return new InputFromCompatInput(compatInput);
    }

    public InputEntityIdVisitor.Long inputEntityLongIdVisitor(org.neo4j.internal.batchimport.input.IdType idType, ReadableGroups groups) {
        switch (idType) {
            case ACTUAL: {
                return new InputEntityIdVisitor.Long(){

                    public void visitNodeId(InputEntityVisitor visitor, long id) {
                        visitor.id(id);
                    }

                    public void visitSourceId(InputEntityVisitor visitor, long id) {
                        visitor.startId(id);
                    }

                    public void visitTargetId(InputEntityVisitor visitor, long id) {
                        visitor.endId(id);
                    }
                };
            }
            case INTEGER: {
                final Group globalGroup = groups.get(null);
                return new InputEntityIdVisitor.Long(){

                    public void visitNodeId(InputEntityVisitor visitor, long id) {
                        visitor.id((Object)id, globalGroup);
                    }

                    public void visitSourceId(InputEntityVisitor visitor, long id) {
                        visitor.startId((Object)id, globalGroup);
                    }

                    public void visitTargetId(InputEntityVisitor visitor, long id) {
                        visitor.endId((Object)id, globalGroup);
                    }
                };
            }
        }
        throw new IllegalStateException("Unexpected value: " + idType);
    }

    public InputEntityIdVisitor.String inputEntityStringIdVisitor(ReadableGroups groups) {
        final Group globalGroup = groups.get(null);
        return new InputEntityIdVisitor.String(){

            public void visitNodeId(InputEntityVisitor visitor, String id) {
                visitor.id((Object)id, globalGroup);
            }

            public void visitSourceId(InputEntityVisitor visitor, String id) {
                visitor.startId((Object)id, globalGroup);
            }

            public void visitTargetId(InputEntityVisitor visitor, String id) {
                visitor.endId((Object)id, globalGroup);
            }
        };
    }

    public Setting<String> additionalJvm() {
        return BootloaderSettings.additional_jvm;
    }

    public Setting<Long> pageCacheMemory() {
        return GraphDatabaseSettings.pagecache_memory;
    }

    public Long pageCacheMemoryValue(String value) {
        return (Long)SettingValueParsers.BYTES.parse(value);
    }

    public ProcedureSignature procedureSignature(QualifiedName name, List<FieldSignature> inputSignature, List<FieldSignature> outputSignature, Mode mode, boolean admin, String deprecated, String description, String warning, boolean eager, boolean caseInsensitive, boolean systemProcedure, boolean internal, boolean allowExpiredCredentials) {
        return new ProcedureSignature(name, inputSignature, outputSignature, mode, admin, deprecated, description, warning, eager, caseInsensitive, systemProcedure, internal, allowExpiredCredentials);
    }

    public long getHighestPossibleNodeCount(Read read, IdGeneratorFactory idGeneratorFactory) {
        return InternalReadOps.countByIdGenerator((IdGeneratorFactory)idGeneratorFactory, (IdType)RecordIdType.NODE).orElseGet(() -> ((Read)read).nodesGetCount());
    }

    public long getHighestPossibleRelationshipCount(Read read, IdGeneratorFactory idGeneratorFactory) {
        return InternalReadOps.countByIdGenerator((IdGeneratorFactory)idGeneratorFactory, (IdType)RecordIdType.RELATIONSHIP).orElseGet(() -> ((Read)read).relationshipsGetCount());
    }

    public String versionLongToString(long storeVersion) {
        if (storeVersion == -1L) {
            return "Unknown";
        }
        Bits bits = Bits.bitsFromLongs((long[])new long[]{storeVersion});
        int length = bits.getShort(8);
        if (length == 0 || length > 7) {
            throw new IllegalArgumentException(String.format(Locale.ENGLISH, "The read version string length %d is not proper.", length));
        }
        char[] result = new char[length];
        for (int i = 0; i < length; ++i) {
            result[i] = (char)bits.getShort(8);
        }
        return new String(result);
    }

    public TestLog testLog() {
        return new TestLogImpl();
    }

    @SuppressForbidden(reason="This is the compat specific use")
    public Log getUserLog(LogService logService, Class<?> loggingClass) {
        return logService.getUserLog(loggingClass);
    }

    @SuppressForbidden(reason="This is the compat specific use")
    public Log getInternalLog(LogService logService, Class<?> loggingClass) {
        return logService.getInternalLog(loggingClass);
    }

    public NodeValue nodeValue(long id, TextArray labels, MapValue properties) {
        return VirtualValues.nodeValue((long)id, (String)String.valueOf(id), (TextArray)labels, (MapValue)properties);
    }

    public Relationship virtualRelationship(long id, Node startNode, Node endNode, RelationshipType type) {
        return new VirtualRelationshipImpl(id, startNode, endNode, type);
    }

    public GdsDatabaseManagementServiceBuilder databaseManagementServiceBuilder(Path storeDir) {
        return new GdsDatabaseManagementServiceBuilderImpl(storeDir);
    }

    @SuppressForbidden(reason="This is the compat specific use")
    public RecordFormats selectRecordFormatForStore(DatabaseLayout databaseLayout, FileSystemAbstraction fs, PageCache pageCache, LogService logService, PageCacheTracer pageCacheTracer) {
        return RecordFormatSelector.selectForStore((RecordDatabaseLayout)((RecordDatabaseLayout)databaseLayout), (FileSystemAbstraction)fs, (PageCache)pageCache, (InternalLogProvider)logService.getInternalLogProvider(), (CursorContextFactory)new CursorContextFactory(pageCacheTracer, EmptyVersionContextSupplier.EMPTY));
    }

    public boolean isNotNumericIndex(IndexCapability indexCapability) {
        return !indexCapability.areValueCategoriesAccepted(new ValueCategory[]{ValueCategory.NUMBER});
    }

    public void setAllowUpgrades(Config.Builder configBuilder, boolean value) {
    }

    public String defaultRecordFormatSetting() {
        return (String)GraphDatabaseSettings.db_format.defaultValue();
    }

    public void configureRecordFormat(Config.Builder configBuilder, String recordFormat) {
        String databaseRecordFormat = recordFormat.toLowerCase(Locale.ENGLISH);
        configBuilder.set(GraphDatabaseSettings.db_format, (Object)databaseRecordFormat);
    }

    public GdsDatabaseLayout databaseLayout(Config config, String databaseName) {
        StorageEngineFactory storageEngineFactory = StorageEngineFactory.selectStorageEngine((Configuration)config);
        DatabaseLayout dbLayout = this.neo4jLayout(config).databaseLayout(databaseName);
        DatabaseLayout databaseLayout = storageEngineFactory.formatSpecificDatabaseLayout(dbLayout);
        return new GdsDatabaseLayoutImpl(databaseLayout);
    }

    @SuppressForbidden(reason="This is the compat specific use")
    public Neo4jLayout neo4jLayout(Config config) {
        return Neo4jLayout.of((Configuration)config);
    }

    public BoltTransactionRunner<?, ?> boltTransactionRunner() {
        return new BoltTransactionRunnerImpl();
    }

    public HostnamePort getLocalBoltAddress(ConnectorPortRegister connectorPortRegister) {
        return connectorPortRegister.getLocalAddress(ConnectorType.BOLT);
    }

    @SuppressForbidden(reason="This is the compat specific use")
    public SslPolicyLoader createSllPolicyLoader(FileSystemAbstraction fileSystem, Config config, LogService logService) {
        return SslPolicyLoader.create((FileSystemAbstraction)fileSystem, (Config)config, (InternalLogProvider)logService.getInternalLogProvider());
    }

    @SuppressForbidden(reason="This is the compat specific use")
    public RecordFormats recordFormatSelector(String databaseName, Config databaseConfig, FileSystemAbstraction fs, LogService logService, GraphDatabaseService databaseService) {
        Neo4jLayout neo4jLayout = Neo4jLayout.of((Configuration)databaseConfig);
        RecordDatabaseLayout recordDatabaseLayout = RecordDatabaseLayout.of((Neo4jLayout)neo4jLayout, (String)databaseName);
        return RecordFormatSelector.selectForStoreOrConfigForNewDbs((Config)databaseConfig, (RecordDatabaseLayout)recordDatabaseLayout, (FileSystemAbstraction)fs, (PageCache)((PageCache)GraphDatabaseApiProxy.resolveDependency((GraphDatabaseService)databaseService, PageCache.class)), (InternalLogProvider)logService.getInternalLogProvider(), (CursorContextFactory)((CursorContextFactory)GraphDatabaseApiProxy.resolveDependency((GraphDatabaseService)databaseService, CursorContextFactory.class)));
    }

    public ExecutionMonitor executionMonitor(final CompatExecutionMonitor compatExecutionMonitor) {
        return new ExecutionMonitor.Adapter(compatExecutionMonitor.checkIntervalMillis(), TimeUnit.MILLISECONDS){

            public void initialize(DependencyResolver dependencyResolver) {
                compatExecutionMonitor.initialize(dependencyResolver);
            }

            public void start(StageExecution execution) {
                compatExecutionMonitor.start(execution);
            }

            public void end(StageExecution execution, long totalTimeMillis) {
                compatExecutionMonitor.end(execution, totalTimeMillis);
            }

            public void done(boolean successful, long totalTimeMillis, String additionalInformation) {
                compatExecutionMonitor.done(successful, totalTimeMillis, additionalInformation);
            }

            public void check(StageExecution execution) {
                compatExecutionMonitor.check(execution);
            }
        };
    }

    @SuppressFBWarnings(value={"NP_LOAD_OF_KNOWN_NULL_VALUE"})
    public UserFunctionSignature userFunctionSignature(QualifiedName name, List<FieldSignature> inputSignature, Neo4jTypes.AnyType type, String description, boolean internal, boolean threadSafe, Optional<String> deprecatedBy) {
        String category = null;
        boolean caseInsensitive = false;
        boolean isBuiltIn = false;
        return new UserFunctionSignature(name, inputSignature, type, (String)deprecatedBy.orElse(null), description, category, caseInsensitive, isBuiltIn, internal, threadSafe);
    }

    @SuppressForbidden(reason="This is the compat API")
    public CallableProcedure callableProcedure(CompatCallableProcedure procedure) {
        return new CallableProcedureImpl(procedure);
    }

    @SuppressForbidden(reason="This is the compat API")
    public CallableUserAggregationFunction callableUserAggregationFunction(CompatUserAggregationFunction function) {
        return new CallableUserAggregationFunctionImpl(function);
    }

    public long transactionId(KernelTransactionHandle kernelTransactionHandle) {
        return kernelTransactionHandle.getTransactionSequenceNumber();
    }

    public void reserveNeo4jIds(IdGeneratorFactory generatorFactory, int size, CursorContext cursorContext) {
        IdGenerator idGenerator = generatorFactory.get((IdType)RecordIdType.NODE);
        idGenerator.nextConsecutiveIdRange(size, false, cursorContext);
    }

    public TransactionalContext newQueryContext(TransactionalContextFactory contextFactory, InternalTransaction tx, String queryText, MapValue queryParameters) {
        return contextFactory.newContext(tx, queryText, queryParameters, QueryExecutionConfiguration.DEFAULT_CONFIG);
    }

    public boolean isCompositeDatabase(GraphDatabaseService databaseService) {
        FabricDatabaseManager databaseManager = (FabricDatabaseManager)GraphDatabaseApiProxy.resolveDependency((GraphDatabaseService)databaseService, FabricDatabaseManager.class);
        return databaseManager.isFabricDatabase(GraphDatabaseApiProxy.databaseId((GraphDatabaseService)databaseService));
    }

    private static final class InputFromCompatInput
    implements Input {
        private final CompatInput delegate;

        private InputFromCompatInput(CompatInput delegate) {
            this.delegate = delegate;
        }

        public InputIterable nodes(Collector badCollector) {
            return this.delegate.nodes(badCollector);
        }

        public InputIterable relationships(Collector badCollector) {
            return this.delegate.relationships(badCollector);
        }

        public org.neo4j.internal.batchimport.input.IdType idType() {
            return this.delegate.idType();
        }

        public ReadableGroups groups() {
            return this.delegate.groups();
        }

        public Input.Estimates calculateEstimates(PropertySizeCalculator propertySizeCalculator) throws IOException {
            return this.delegate.calculateEstimates((values, kernelTransaction) -> propertySizeCalculator.calculateSize(values, kernelTransaction.cursorContext(), kernelTransaction.memoryTracker()));
        }
    }
}

