/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.summary;

import java.util.stream.IntStream;
import org.neo4j.driver.summary.SummaryCounters;

public record InternalSummaryCounters(int nodesCreated, int nodesDeleted, int relationshipsCreated, int relationshipsDeleted, int propertiesSet, int labelsAdded, int labelsRemoved, int indexesAdded, int indexesRemoved, int constraintsAdded, int constraintsRemoved, int systemUpdates) implements SummaryCounters
{
    public static final InternalSummaryCounters EMPTY_STATS = new InternalSummaryCounters(0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0);

    @Override
    public boolean containsUpdates() {
        return IntStream.of(this.nodesCreated, this.nodesDeleted, this.relationshipsCreated, this.relationshipsDeleted, this.propertiesSet, this.labelsAdded, this.labelsRemoved, this.indexesAdded, this.indexesRemoved, this.constraintsAdded, this.constraintsRemoved).anyMatch(this::isPositive);
    }

    @Override
    public boolean containsSystemUpdates() {
        return this.isPositive(this.systemUpdates);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InternalSummaryCounters that = (InternalSummaryCounters)o;
        return this.nodesCreated == that.nodesCreated && this.nodesDeleted == that.nodesDeleted && this.relationshipsCreated == that.relationshipsCreated && this.relationshipsDeleted == that.relationshipsDeleted && this.propertiesSet == that.propertiesSet && this.labelsAdded == that.labelsAdded && this.labelsRemoved == that.labelsRemoved && this.indexesAdded == that.indexesAdded && this.indexesRemoved == that.indexesRemoved && this.constraintsAdded == that.constraintsAdded && this.constraintsRemoved == that.constraintsRemoved && this.systemUpdates == that.systemUpdates;
    }

    private boolean isPositive(int value) {
        return value > 0;
    }

    @Override
    public String toString() {
        return "InternalSummaryCounters{nodesCreated=" + this.nodesCreated + ", nodesDeleted=" + this.nodesDeleted + ", relationshipsCreated=" + this.relationshipsCreated + ", relationshipsDeleted=" + this.relationshipsDeleted + ", propertiesSet=" + this.propertiesSet + ", labelsAdded=" + this.labelsAdded + ", labelsRemoved=" + this.labelsRemoved + ", indexesAdded=" + this.indexesAdded + ", indexesRemoved=" + this.indexesRemoved + ", constraintsAdded=" + this.constraintsAdded + ", constraintsRemoved=" + this.constraintsRemoved + ", systemUpdates=" + this.systemUpdates + "}";
    }
}

