/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.logging;

import java.util.Objects;
import org.neo4j.driver.Logger;

final class SystemLogger
implements Logger {
    private final System.Logger delegate;
    private final boolean isDebugEnabled;
    private final boolean isTraceEnabled;

    SystemLogger(System.Logger delegate) {
        this.delegate = Objects.requireNonNull(delegate);
        this.isDebugEnabled = delegate.isLoggable(System.Logger.Level.DEBUG);
        this.isTraceEnabled = delegate.isLoggable(System.Logger.Level.TRACE);
    }

    @Override
    public void error(String message, Throwable cause) {
        this.delegate.log(System.Logger.Level.ERROR, message, cause);
    }

    @Override
    public void info(String message, Object ... params) {
        try {
            this.delegate.log(System.Logger.Level.INFO, message.formatted(params));
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    @Override
    public void warn(String message, Object ... params) {
        try {
            this.delegate.log(System.Logger.Level.WARNING, message.formatted(params));
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    @Override
    public void warn(String message, Throwable cause) {
        this.delegate.log(System.Logger.Level.WARNING, message, cause);
    }

    @Override
    public void debug(String message, Object ... params) {
        try {
            this.delegate.log(System.Logger.Level.DEBUG, message.formatted(params));
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    @Override
    public void debug(String message, Throwable throwable) {
        this.delegate.log(System.Logger.Level.DEBUG, message, throwable);
    }

    @Override
    public void trace(String message, Object ... params) {
        try {
            this.delegate.log(System.Logger.Level.TRACE, message.formatted(params));
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    @Override
    public boolean isTraceEnabled() {
        return this.isTraceEnabled;
    }

    @Override
    public boolean isDebugEnabled() {
        return this.isDebugEnabled;
    }
}

